/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator.cache;

import java.util.HashMap;
import java.util.HashSet;
import javax.sql.DataSource;
import org.jfaster.mango.binding.InvocationContext;
import org.jfaster.mango.descriptor.MethodDescriptor;
import org.jfaster.mango.operator.BatchUpdateOperator;
import org.jfaster.mango.operator.Config;
import org.jfaster.mango.operator.cache.CacheDriver;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.stat.InvocationStat;
import org.jfaster.mango.util.Iterables;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class CacheableBatchUpdateOperator
extends BatchUpdateOperator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CacheableBatchUpdateOperator.class);
    private CacheDriver driver;

    public CacheableBatchUpdateOperator(ASTRootNode rootNode, MethodDescriptor md, CacheDriver cacheDriver, Config config) {
        super(rootNode, md, config);
        this.driver = cacheDriver;
    }

    @Override
    public Object execute(Object[] values, InvocationStat stat) {
        Iterables iterables = this.getIterables(values);
        if (iterables.isEmpty()) {
            return this.transformer.transform(new int[0]);
        }
        HashSet<String> keys = new HashSet<String>(iterables.size() * 2);
        HashMap<DataSource, BatchUpdateOperator.Group> groupMap = new HashMap<DataSource, BatchUpdateOperator.Group>();
        int t = 0;
        for (Object obj : iterables) {
            InvocationContext context = this.invocationContextFactory.newInvocationContext(new Object[]{obj});
            keys.add(this.driver.getCacheKey(context));
            this.group(context, groupMap, t++);
        }
        int[] ints = this.executeDb(groupMap, t, stat);
        if (logger.isDebugEnabled()) {
            logger.debug("Cache delete for multiple keys {}", (Object)keys);
        }
        this.driver.batchDeleteFromCache(keys, stat);
        return this.transformer.transform(ints);
    }
}

