/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfaster.mango.binding.BindingException;
import org.jfaster.mango.binding.InvocationContext;
import org.jfaster.mango.descriptor.MethodDescriptor;
import org.jfaster.mango.exception.DescriptionException;
import org.jfaster.mango.invoker.GetterInvoker;
import org.jfaster.mango.invoker.InvokerCache;
import org.jfaster.mango.operator.Config;
import org.jfaster.mango.operator.QueryOperator;
import org.jfaster.mango.operator.cache.CacheDriver;
import org.jfaster.mango.operator.cache.CacheableUpdateOperator;
import org.jfaster.mango.operator.cache.NullObject;
import org.jfaster.mango.parser.ASTJDBCIterableParameter;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.stat.InvocationStat;
import org.jfaster.mango.util.Arrays;
import org.jfaster.mango.util.Iterables;
import org.jfaster.mango.util.Strings;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class CacheableQueryOperator
extends QueryOperator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CacheableUpdateOperator.class);
    private CacheDriver driver;
    GetterInvoker propertyOfMapperInvoker;

    public CacheableQueryOperator(ASTRootNode rootNode, MethodDescriptor md, CacheDriver cacheDriver, Config config) {
        super(rootNode, md, config);
        this.driver = cacheDriver;
        List<ASTJDBCIterableParameter> jips = rootNode.getJDBCIterableParameters();
        if (jips.size() > 1) {
            throw new DescriptionException("if use cache, sql's in clause expected less than or equal 1 but " + jips.size());
        }
        if (this.driver.isUseMultipleKeys()) {
            String propertyOfMapper = this.driver.getPropertyOfMapper().toLowerCase();
            List<GetterInvoker> invokers = InvokerCache.getGetterInvokers(this.returnDescriptor.getMappedClass());
            for (GetterInvoker invoker : invokers) {
                if (!Strings.underscoreName(invoker.getName()).equals(propertyOfMapper)) continue;
                this.propertyOfMapperInvoker = invoker;
            }
            if (this.propertyOfMapperInvoker == null) {
                throw new BindingException("if use cache and sql has one in clause, property " + propertyOfMapper + " of " + this.returnDescriptor.getMappedClass() + " expected readable but not");
            }
        }
    }

    @Override
    public Object execute(Object[] values, InvocationStat stat) {
        InvocationContext context = this.invocationContextFactory.newInvocationContext(values);
        return this.driver.isUseMultipleKeys() ? this.multipleKeysCache(context, this.rowMapper.getMappedClass(), this.driver.getOnlyCacheByClass(), stat) : this.singleKeyCache(context, stat);
    }

    private <T, U> Object multipleKeysCache(InvocationContext context, Class<T> mappedClass, Class<U> cacheByActualClass, InvocationStat stat) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        boolean isCacheNullObj = this.driver.isCacheNullObject();
        Set<String> keys = this.driver.getCacheKeys(context);
        if (keys.isEmpty()) {
            return this.EmptyObject();
        }
        Map<String, Object> cachedResults = this.driver.getBulkFromCache(keys, stat);
        AddableObject<T> addableObj = new AddableObject<T>(mappedClass);
        int hitNum = 0;
        ArrayList<String> hitKeys = isDebugEnabled ? new ArrayList<String>() : null;
        ArrayList<String> missKeys = isDebugEnabled ? new ArrayList<String>() : null;
        HashSet<U> missCacheByActualObjs = new HashSet<U>();
        for (Object cacheByActualObj : new Iterables(this.driver.getOnlyCacheByObj(context))) {
            Object value;
            String key = this.driver.getCacheKey(cacheByActualObj);
            Object object = value = cachedResults != null ? cachedResults.get(key) : null;
            if (value == null) {
                missCacheByActualObjs.add(cacheByActualClass.cast(cacheByActualObj));
                if (!isDebugEnabled) continue;
                missKeys.add(key);
                continue;
            }
            ++hitNum;
            if (!this.isNullObject(value)) {
                addableObj.add(mappedClass.cast(value));
            }
            if (!isDebugEnabled) continue;
            hitKeys.add(key);
        }
        stat.recordHits(hitNum);
        stat.recordMisses(missCacheByActualObjs.size());
        if (isDebugEnabled) {
            if (!hitKeys.isEmpty()) {
                logger.debug("Cache hit for multiple keys {}", (Object)hitKeys);
            }
            if (!missKeys.isEmpty()) {
                logger.debug("Cache miss for multiple keys {}", (Object)missKeys);
            }
        }
        if (!missCacheByActualObjs.isEmpty()) {
            this.driver.setOnlyCacheByObj(context, missCacheByActualObjs);
            Object dbValues = this.execute(context, stat);
            ArrayList<String> needSetKeys = isDebugEnabled ? new ArrayList<String>() : null;
            for (Object dbValue : new Iterables(dbValues)) {
                addableObj.add(mappedClass.cast(dbValue));
                Object propertyObj = this.propertyOfMapperInvoker.invoke(dbValue);
                if (propertyObj == null) {
                    throw new NullPointerException("property " + this.propertyOfMapperInvoker.getName() + " of " + mappedClass + " is null, please check return type");
                }
                U cacheByActualObj = cacheByActualClass.cast(propertyObj);
                String key = this.driver.getCacheKey(cacheByActualObj);
                this.driver.setToCache(key, dbValue, stat);
                if (isCacheNullObj) {
                    missCacheByActualObjs.remove(cacheByActualObj);
                }
                if (!isDebugEnabled) continue;
                needSetKeys.add(key);
            }
            if (isDebugEnabled && !needSetKeys.isEmpty()) {
                logger.debug("Cache set for multiple keys {}, exptime: {}", (Object)needSetKeys, (Object)this.driver.getExptimeSeconds());
            }
            if (isCacheNullObj && !missCacheByActualObjs.isEmpty()) {
                ArrayList<String> needAddKeys = isDebugEnabled ? new ArrayList<String>() : null;
                for (Object missCacheByActualObj : missCacheByActualObjs) {
                    String key = this.driver.getCacheKey(missCacheByActualObj);
                    this.driver.addToCache(key, this.createNullObject(), stat);
                    if (!isDebugEnabled) continue;
                    needAddKeys.add(key);
                }
                if (isDebugEnabled && !needAddKeys.isEmpty()) {
                    logger.debug("Cache add for multiple keys {}, exptime: {}", (Object)needAddKeys, (Object)this.driver.getExptimeSeconds());
                }
            }
        }
        return addableObj.getReturn();
    }

    private Object singleKeyCache(InvocationContext context, InvocationStat stat) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        String key = this.driver.getCacheKey(context);
        Object value = this.driver.getFromCache(key, stat);
        if (value == null) {
            stat.recordMisses(1);
            if (isDebugEnabled) {
                logger.debug("Cache miss for single key [{}]", (Object)key);
            }
            if ((value = this.execute(context, stat)) != null) {
                if (this.driver.isCacheEmptyList() || this.isNotEmptyList(value)) {
                    this.driver.setToCache(key, value, stat);
                    if (isDebugEnabled) {
                        logger.debug("Cache set for single key [{}], exptime: {}", (Object)key, (Object)this.driver.getExptimeSeconds());
                    }
                }
            } else if (this.driver.isCacheNullObject()) {
                this.driver.addToCache(key, this.createNullObject(), stat);
                if (isDebugEnabled) {
                    logger.debug("Cache add for single key [{}], exptime: {}", (Object)key, (Object)this.driver.getExptimeSeconds());
                }
            }
        } else {
            stat.recordHits(1);
            if (isDebugEnabled) {
                logger.debug("Cache hit for single key [{}]", (Object)key);
            }
            if (this.isNullObject(value)) {
                value = null;
            }
        }
        return value;
    }

    private boolean isNotEmptyList(Object value) {
        Iterables iterables = new Iterables(value);
        return !iterables.isIterable() || !iterables.isEmpty();
    }

    private NullObject createNullObject() {
        return new NullObject();
    }

    private boolean isNullObject(Object obj) {
        return obj instanceof NullObject;
    }

    private class AddableObject<T> {
        List<T> hitValueList;
        Set<T> hitValueSet;
        Class<T> valueClass;

        private AddableObject(Class<T> valueClass) {
            if (CacheableQueryOperator.this.returnDescriptor.isSetAssignable()) {
                this.hitValueSet = new HashSet<T>();
            } else {
                this.hitValueList = CacheableQueryOperator.this.returnDescriptor.isArrayList() ? new ArrayList<T>() : new LinkedList<T>();
            }
            this.valueClass = valueClass;
        }

        public void add(T v) {
            if (this.hitValueList != null) {
                this.hitValueList.add(v);
            } else {
                this.hitValueSet.add(v);
            }
        }

        public Object getReturn() {
            if (CacheableQueryOperator.this.returnDescriptor.isListAssignable() || CacheableQueryOperator.this.returnDescriptor.isCollection()) {
                return this.hitValueList;
            }
            if (CacheableQueryOperator.this.returnDescriptor.isSetAssignable()) {
                return this.hitValueSet;
            }
            if (CacheableQueryOperator.this.returnDescriptor.isArray()) {
                return Arrays.toArray(this.hitValueList, this.valueClass);
            }
            return !this.hitValueList.isEmpty() ? this.hitValueList.get(0) : null;
        }

        public String toString() {
            return this.hitValueList != null ? this.hitValueList.toString() : this.hitValueSet.toString();
        }
    }
}

