/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator.cache;

import java.util.List;
import java.util.Set;
import org.jfaster.mango.binding.InvocationContext;
import org.jfaster.mango.descriptor.MethodDescriptor;
import org.jfaster.mango.exception.DescriptionException;
import org.jfaster.mango.operator.Config;
import org.jfaster.mango.operator.UpdateOperator;
import org.jfaster.mango.operator.cache.CacheDriver;
import org.jfaster.mango.parser.ASTJDBCIterableParameter;
import org.jfaster.mango.parser.ASTRootNode;
import org.jfaster.mango.stat.InvocationStat;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class CacheableUpdateOperator
extends UpdateOperator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CacheableUpdateOperator.class);
    private CacheDriver driver;

    public CacheableUpdateOperator(ASTRootNode rootNode, MethodDescriptor md, CacheDriver cacheDriver, Config config) {
        super(rootNode, md, config);
        this.driver = cacheDriver;
        List<ASTJDBCIterableParameter> jips = rootNode.getJDBCIterableParameters();
        if (jips.size() > 1) {
            throw new DescriptionException("if use cache, sql's in clause expected less than or equal 1 but " + jips.size());
        }
    }

    @Override
    public Object execute(Object[] values, InvocationStat stat) {
        InvocationContext context = this.invocationContextFactory.newInvocationContext(values);
        Object r = this.execute(context, stat);
        if (this.driver.isUseMultipleKeys()) {
            Set<String> keys = this.driver.getCacheKeys(context);
            if (!keys.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Cache delete for multiple keys {}", (Object)keys);
                }
                this.driver.batchDeleteFromCache(keys, stat);
            }
        } else {
            String key = this.driver.getCacheKey(context);
            if (logger.isDebugEnabled()) {
                logger.debug("Cache delete for single key [{}]", (Object)key);
            }
            this.driver.deleteFromCache(key, stat);
        }
        return r;
    }
}

