/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator.cache;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jfaster.mango.operator.cache.SimpleCacheHandler;
import org.jfaster.mango.util.Ticker;

public class LocalCacheHandler
extends SimpleCacheHandler {
    private final ConcurrentHashMap<String, Entry> cache = new ConcurrentHashMap();
    private final Ticker ticker;

    public LocalCacheHandler() {
        this(Ticker.systemTicker());
    }

    public LocalCacheHandler(Ticker ticker) {
        this.ticker = ticker;
    }

    public Object get(String key) {
        return this.get(key, null);
    }

    public Map<String, Object> getBulk(Set<String> keys) {
        return this.getBulk(keys, null);
    }

    @Override
    public Object get(String key, Type type) {
        Entry entry = this.cache.get(key);
        if (entry == null) {
            return null;
        }
        long now = this.ticker.read();
        if (entry.getExpireTime() >= now) {
            return entry.getValue();
        }
        this.cache.remove(key, entry);
        return null;
    }

    @Override
    public Map<String, Object> getBulk(Set<String> keys, Type type) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : keys) {
            Object value = this.get(key, type);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void set(String key, Object value, int exptimeSeconds) {
        long now = this.ticker.read();
        Entry entry = new Entry(value, now + TimeUnit.SECONDS.toNanos(exptimeSeconds));
        this.cache.put(key, entry);
    }

    @Override
    public void delete(String key) {
        this.cache.remove(key);
    }

    @Override
    public void add(String key, Object value, int exptimeSeconds) {
        long now = this.ticker.read();
        Entry entry = new Entry(value, now + TimeUnit.SECONDS.toNanos(exptimeSeconds));
        this.cache.putIfAbsent(key, entry);
    }

    private static class Entry {
        private Object value;
        private long expireTime;

        public Entry(Object value, long expireTime) {
            this.value = value;
            this.expireTime = expireTime;
        }

        public Object getValue() {
            return this.value;
        }

        public long getExpireTime() {
            return this.expireTime;
        }
    }
}

