/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator.generator;

import javax.sql.DataSource;
import org.jfaster.mango.binding.InvocationContext;
import org.jfaster.mango.datasource.DataSourceFactoryGroup;
import org.jfaster.mango.datasource.DataSourceType;
import org.jfaster.mango.operator.generator.DataSourceGenerator;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public abstract class AbstractDataSourceGenerator
implements DataSourceGenerator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractDataSourceGenerator.class);
    private final DataSourceFactoryGroup dataSourceFactoryGroup;
    private final DataSourceType dataSourceType;

    protected AbstractDataSourceGenerator(DataSourceFactoryGroup dataSourceFactoryGroup, DataSourceType dataSourceType) {
        this.dataSourceFactoryGroup = dataSourceFactoryGroup;
        this.dataSourceType = dataSourceType;
    }

    @Override
    public DataSource getDataSource(InvocationContext context, Class<?> daoClass) {
        String dataSourceFactoryName = this.getDataSourceFactoryName(context);
        if (logger.isDebugEnabled()) {
            logger.debug("The name of datasource factory is [" + dataSourceFactoryName + "]");
        }
        DataSource ds = this.dataSourceType == DataSourceType.MASTER ? this.dataSourceFactoryGroup.getMasterDataSource(dataSourceFactoryName) : this.dataSourceFactoryGroup.getSlaveDataSource(dataSourceFactoryName, daoClass);
        return ds;
    }

    public abstract String getDataSourceFactoryName(InvocationContext var1);
}

