/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator.generator;

import java.lang.reflect.Type;
import javax.annotation.Nullable;
import org.jfaster.mango.annotation.DatabaseShardingBy;
import org.jfaster.mango.annotation.Sharding;
import org.jfaster.mango.annotation.ShardingBy;
import org.jfaster.mango.binding.BindingParameter;
import org.jfaster.mango.binding.BindingParameterInvoker;
import org.jfaster.mango.binding.ParameterContext;
import org.jfaster.mango.datasource.DataSourceFactoryGroup;
import org.jfaster.mango.datasource.DataSourceType;
import org.jfaster.mango.descriptor.ParameterDescriptor;
import org.jfaster.mango.exception.DescriptionException;
import org.jfaster.mango.exception.IncorrectParameterTypeException;
import org.jfaster.mango.operator.generator.DataSourceGenerator;
import org.jfaster.mango.operator.generator.ShardedDataSourceGenerator;
import org.jfaster.mango.operator.generator.SimpleDataSourceGenerator;
import org.jfaster.mango.sharding.DatabaseShardingStrategy;
import org.jfaster.mango.sharding.NotUseDatabaseShardingStrategy;
import org.jfaster.mango.sharding.NotUseShardingStrategy;
import org.jfaster.mango.util.reflect.Reflection;
import org.jfaster.mango.util.reflect.TypeToken;
import org.jfaster.mango.util.reflect.TypeWrapper;

public class DataSourceGeneratorFactory {
    private final DataSourceFactoryGroup dataSourceFactoryGroup;

    public DataSourceGeneratorFactory(DataSourceFactoryGroup dataSourceFactoryGroup) {
        this.dataSourceFactoryGroup = dataSourceFactoryGroup;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataSourceGenerator getDataSourceGenerator(DataSourceType dataSourceType, @Nullable Sharding shardingAnno, String dataSourceFactoryName, ParameterContext context) {
        void var10_13;
        DatabaseShardingStrategy strategy = this.getDatabaseShardingStrategy(shardingAnno);
        TypeToken<DatabaseShardingStrategy> strategyToken = null;
        if (strategy != null) {
            strategyToken = TypeToken.of(strategy.getClass()).resolveFatherClass(DatabaseShardingStrategy.class);
        }
        int shardingParameterNum = 0;
        String shardingParameterName = null;
        String shardingParameterProperty = null;
        for (ParameterDescriptor pd : context.getParameterDescriptors()) {
            DatabaseShardingBy databaseShardingByAnno = pd.getAnnotation(DatabaseShardingBy.class);
            if (databaseShardingByAnno != null) {
                shardingParameterName = context.getParameterNameByPosition(pd.getPosition());
                shardingParameterProperty = databaseShardingByAnno.value();
                ++shardingParameterNum;
                continue;
            }
            ShardingBy shardingByAnno = pd.getAnnotation(ShardingBy.class);
            if (shardingByAnno == null) continue;
            shardingParameterName = context.getParameterNameByPosition(pd.getPosition());
            shardingParameterProperty = shardingByAnno.value();
            ++shardingParameterNum;
        }
        if (strategy != null) {
            if (shardingParameterNum != true) throw new DescriptionException("if @Sharding.databaseShardingStrategy is defined, need one and only one @DatabaseShardingBy on method's parameter but found " + shardingParameterNum + ", please note that @ShardingBy = @TableShardingBy + @DatabaseShardingBy");
            BindingParameterInvoker shardingParameterInvoker = context.getBindingParameterInvoker(BindingParameter.create(shardingParameterName, shardingParameterProperty, null));
            Type shardingParameterType = shardingParameterInvoker.getTargetType();
            TypeWrapper tw = new TypeWrapper(shardingParameterType);
            Class<?> mappedClass = tw.getMappedClass();
            if (mappedClass == null || tw.isIterable()) {
                throw new IncorrectParameterTypeException("the type of parameter Modified @DatabaseShardingBy is error, type is " + shardingParameterType + ", please note that @ShardingBy = @TableShardingBy + @DatabaseShardingBy");
            }
            TypeToken<?> shardToken = TypeToken.of(shardingParameterType);
            if (!strategyToken.isAssignableFrom(shardToken.wrap())) {
                throw new ClassCastException("DatabaseShardingStrategy[" + strategy.getClass() + "]'s generic type[" + strategyToken.getType() + "] must be assignable from the type of parameter Modified @DatabaseShardingBy [" + shardToken.getType() + "], please note that @ShardingBy = @TableShardingBy + @DatabaseShardingBy");
            }
            ShardedDataSourceGenerator shardedDataSourceGenerator = new ShardedDataSourceGenerator(this.dataSourceFactoryGroup, dataSourceType, shardingParameterInvoker, strategy);
            return var10_13;
        } else {
            SimpleDataSourceGenerator simpleDataSourceGenerator = new SimpleDataSourceGenerator(this.dataSourceFactoryGroup, dataSourceType, dataSourceFactoryName);
        }
        return var10_13;
    }

    @Nullable
    private DatabaseShardingStrategy getDatabaseShardingStrategy(@Nullable Sharding shardingAnno) {
        if (shardingAnno == null) {
            return null;
        }
        Class<? extends DatabaseShardingStrategy> strategyClass = shardingAnno.databaseShardingStrategy();
        if (!strategyClass.equals(NotUseDatabaseShardingStrategy.class)) {
            DatabaseShardingStrategy strategy = Reflection.instantiateClass(strategyClass);
            return strategy;
        }
        strategyClass = shardingAnno.shardingStrategy();
        if (!strategyClass.equals(NotUseShardingStrategy.class)) {
            DatabaseShardingStrategy strategy = Reflection.instantiateClass(strategyClass);
            return strategy;
        }
        return null;
    }
}

