/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.operator.generator;

import java.lang.reflect.Type;
import javax.annotation.Nullable;
import org.jfaster.mango.annotation.Sharding;
import org.jfaster.mango.annotation.ShardingBy;
import org.jfaster.mango.annotation.TableShardingBy;
import org.jfaster.mango.binding.BindingParameter;
import org.jfaster.mango.binding.BindingParameterInvoker;
import org.jfaster.mango.binding.ParameterContext;
import org.jfaster.mango.descriptor.ParameterDescriptor;
import org.jfaster.mango.exception.DescriptionException;
import org.jfaster.mango.exception.IncorrectParameterTypeException;
import org.jfaster.mango.operator.generator.ShardedTableGenerator;
import org.jfaster.mango.operator.generator.SimpleTableGenerator;
import org.jfaster.mango.operator.generator.TableGenerator;
import org.jfaster.mango.sharding.NotUseShardingStrategy;
import org.jfaster.mango.sharding.NotUseTableShardingStrategy;
import org.jfaster.mango.sharding.TableShardingStrategy;
import org.jfaster.mango.util.reflect.Reflection;
import org.jfaster.mango.util.reflect.TypeToken;
import org.jfaster.mango.util.reflect.TypeWrapper;

public class TableGeneratorFactory {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TableGenerator getTableGenerator(@Nullable Sharding shardingAnno, @Nullable String table, boolean isSqlUseGlobalTable, ParameterContext context) {
        void var12_15;
        boolean isUseTableShardingStrategy;
        TableShardingStrategy strategy = this.getTableShardingStrategy(shardingAnno);
        TypeToken<TableShardingStrategy> strategyToken = null;
        if (strategy != null) {
            strategyToken = TypeToken.of(strategy.getClass()).resolveFatherClass(TableShardingStrategy.class);
        }
        boolean isUseGlobalTable = table != null;
        boolean bl = isUseTableShardingStrategy = strategy != null;
        if (isSqlUseGlobalTable && !isUseGlobalTable) {
            throw new DescriptionException("if sql use global table '#table', @DB.table must be defined");
        }
        if (isUseTableShardingStrategy && !isUseGlobalTable) {
            throw new DescriptionException("if @Sharding.tableShardingStrategy is defined, @DB.table must be defined");
        }
        int num = 0;
        String parameterName = null;
        String propertyPath = null;
        for (ParameterDescriptor pd : context.getParameterDescriptors()) {
            TableShardingBy tableShardingByAnno = pd.getAnnotation(TableShardingBy.class);
            if (tableShardingByAnno != null) {
                parameterName = context.getParameterNameByPosition(pd.getPosition());
                propertyPath = tableShardingByAnno.value();
                ++num;
                continue;
            }
            ShardingBy shardingByAnno = pd.getAnnotation(ShardingBy.class);
            if (shardingByAnno == null) continue;
            parameterName = context.getParameterNameByPosition(pd.getPosition());
            propertyPath = shardingByAnno.value();
            ++num;
        }
        if (isUseTableShardingStrategy) {
            if (num != true) throw new DescriptionException("if @Sharding.tableShardingStrategy is defined, need one and only one @TableShardingBy on method's parameter but found " + num + ", please note that @ShardingBy = @TableShardingBy + @DatabaseShardingBy");
            BindingParameter bp = BindingParameter.create(parameterName, propertyPath, null);
            BindingParameterInvoker invoker = context.getBindingParameterInvoker(bp);
            Type targetType = invoker.getTargetType();
            TypeWrapper tw = new TypeWrapper(targetType);
            Class<?> mappedClass = tw.getMappedClass();
            if (mappedClass == null || tw.isIterable()) {
                throw new IncorrectParameterTypeException("the type of parameter Modified @TableShardingBy is error, type is " + targetType + ", please note that @ShardingBy = @TableShardingBy + @DatabaseShardingBy");
            }
            TypeToken<?> shardToken = TypeToken.of(targetType);
            if (!strategyToken.isAssignableFrom(shardToken.wrap())) {
                throw new ClassCastException("TableShardingStrategy[" + strategy.getClass() + "]'s generic type[" + strategyToken.getType() + "] must be assignable from the type of parameter Modified @TableShardingBy [" + shardToken.getType() + "], please note that @ShardingBy = @TableShardingBy + @DatabaseShardingBy");
            }
            ShardedTableGenerator shardedTableGenerator = new ShardedTableGenerator(table, invoker, strategy);
            return var12_15;
        } else {
            SimpleTableGenerator simpleTableGenerator = new SimpleTableGenerator(table);
        }
        return var12_15;
    }

    @Nullable
    private TableShardingStrategy getTableShardingStrategy(@Nullable Sharding shardingAnno) {
        if (shardingAnno == null) {
            return null;
        }
        Class<? extends TableShardingStrategy> strategyClass = shardingAnno.tableShardingStrategy();
        if (!strategyClass.equals(NotUseTableShardingStrategy.class)) {
            TableShardingStrategy strategy = Reflection.instantiateClass(strategyClass);
            return strategy;
        }
        strategyClass = shardingAnno.shardingStrategy();
        if (!strategyClass.equals(NotUseShardingStrategy.class)) {
            TableShardingStrategy strategy = Reflection.instantiateClass(strategyClass);
            return strategy;
        }
        return null;
    }
}

