/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jfaster.mango.binding.BindingParameter;
import org.jfaster.mango.binding.BindingParameterInvoker;
import org.jfaster.mango.binding.InvocationContext;
import org.jfaster.mango.parser.AbstractExpression;
import org.jfaster.mango.parser.ParameterBean;
import org.jfaster.mango.parser.Parser;
import org.jfaster.mango.parser.ParserVisitor;
import org.jfaster.mango.util.Iterables;

public class ASTExpressionParameter
extends AbstractExpression
implements ParameterBean {
    private BindingParameter bindingParameter;
    private BindingParameterInvoker bindingParameterInvoker;

    public ASTExpressionParameter(int i) {
        super(i);
    }

    public ASTExpressionParameter(Parser p, int i) {
        super(p, i);
    }

    public void init(String str) {
        Pattern p = Pattern.compile(":(\\w+)(\\.\\w+)*");
        Matcher m = p.matcher(str);
        if (!m.matches()) {
            throw new IllegalStateException("Can't compile string '" + str + "'");
        }
        String parameterName = m.group(1);
        String propertyPath = str.substring(m.end(1));
        if (!propertyPath.isEmpty()) {
            propertyPath = propertyPath.substring(1);
        }
        this.bindingParameter = BindingParameter.create(parameterName, propertyPath, null);
    }

    @Override
    public BindingParameter getBindingParameter() {
        return this.bindingParameter;
    }

    @Override
    public void setBindingParameter(BindingParameter bindingParameter) {
        this.bindingParameter = bindingParameter;
    }

    @Override
    public boolean evaluate(InvocationContext context) {
        Iterables itr;
        if (this.bindingParameterInvoker == null) {
            throw new NullPointerException("invoker must set");
        }
        Object obj = context.getNullableBindingValue(this.bindingParameterInvoker);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return !((String)obj).isEmpty();
        }
        if (obj != null && (itr = new Iterables(obj)).isIterable()) {
            return !itr.isEmpty();
        }
        return obj != null;
    }

    @Override
    public Object value(InvocationContext context) {
        if (this.bindingParameterInvoker == null) {
            throw new NullPointerException("invoker must set");
        }
        return context.getNullableBindingValue(this.bindingParameterInvoker);
    }

    @Override
    public String toString() {
        return super.toString() + "{fullName=" + this.getFullName() + ", parameterName=" + this.bindingParameter.getParameterName() + ", propertyPath=" + this.bindingParameter.getPropertyPath() + "}";
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public String getFullName() {
        return this.bindingParameter.getFullName();
    }

    @Override
    public void setBindingParameterInvoker(BindingParameterInvoker bindingParameterInvoker) {
        this.bindingParameterInvoker = bindingParameterInvoker;
    }
}

