/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jfaster.mango.binding.BindingParameter;
import org.jfaster.mango.binding.BindingParameterInvoker;
import org.jfaster.mango.binding.InvocationContext;
import org.jfaster.mango.parser.AbstractRenderableNode;
import org.jfaster.mango.parser.ParameterBean;
import org.jfaster.mango.parser.Parser;
import org.jfaster.mango.parser.ParserVisitor;
import org.jfaster.mango.type.TypeHandler;
import org.jfaster.mango.util.Strings;
import org.jfaster.mango.util.jdbc.JdbcType;

public class ASTJDBCParameter
extends AbstractRenderableNode
implements ParameterBean {
    private BindingParameter bindingParameter;
    private BindingParameterInvoker bindingParameterInvoker;
    private TypeHandler<?> typeHandler;

    public ASTJDBCParameter(int i) {
        super(i);
    }

    public ASTJDBCParameter(Parser p, int i) {
        super(p, i);
    }

    public void init(String str) {
        Pattern p = Pattern.compile(":(\\w+)((\\.\\w+)*)(\\@\\w+)?");
        Matcher m = p.matcher(str);
        if (!m.matches()) {
            throw new IllegalStateException("Can't compile string '" + str + "'");
        }
        String group1 = m.group(1);
        String group2 = m.group(2);
        String group4 = m.group(4);
        String parameterName = group1;
        String propertyPath = Strings.isNotEmpty(group2) ? group2.substring(1) : "";
        JdbcType jdbcType = null;
        String jdbcTypeStr = null;
        if (group4 != null) {
            try {
                jdbcTypeStr = group4.substring(1).toUpperCase();
                jdbcType = JdbcType.valueOf(jdbcTypeStr);
            }
            catch (Exception e) {
                throw new IllegalStateException("error jdbc type '" + jdbcTypeStr + "'");
            }
        }
        this.bindingParameter = BindingParameter.create(parameterName, propertyPath, jdbcType);
    }

    @Override
    public BindingParameter getBindingParameter() {
        return this.bindingParameter;
    }

    @Override
    public void setBindingParameter(BindingParameter bindingParameter) {
        this.bindingParameter = bindingParameter;
    }

    @Override
    public boolean render(InvocationContext context) {
        if (this.bindingParameterInvoker == null) {
            throw new NullPointerException("invoker must set");
        }
        context.writeToSqlBuffer("?");
        Object obj = context.getNullableBindingValue(this.bindingParameterInvoker);
        context.appendToArgs(obj, this.typeHandler);
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + "{fullName=" + this.getFullName() + ", parameterName=" + this.bindingParameter.getParameterName() + ", propertyPath=" + this.bindingParameter.getPropertyPath() + "}";
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public String getFullName() {
        return this.bindingParameter.getFullName();
    }

    @Override
    public void setBindingParameterInvoker(BindingParameterInvoker bindingParameterInvoker) {
        this.bindingParameterInvoker = bindingParameterInvoker;
    }

    public void setTypeHandler(TypeHandler<?> typeHandler) {
        this.typeHandler = typeHandler;
    }
}

