/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jfaster.mango.binding.BindingParameter;
import org.jfaster.mango.binding.BindingParameterInvoker;
import org.jfaster.mango.binding.InvocationContext;
import org.jfaster.mango.parser.AbstractRenderableNode;
import org.jfaster.mango.parser.ParameterBean;
import org.jfaster.mango.parser.Parser;
import org.jfaster.mango.parser.ParserVisitor;

public class ASTJoinParameter
extends AbstractRenderableNode
implements ParameterBean {
    private BindingParameter bindingParameter;
    private BindingParameterInvoker bindingParameterInvoker;

    public ASTJoinParameter(int id) {
        super(id);
    }

    public ASTJoinParameter(Parser p, int id) {
        super(p, id);
    }

    public void init(String str) {
        String parameterName;
        Pattern p = Pattern.compile("#\\{\\s*(:(\\w+)(\\.\\w+)*)\\s*\\}", 2);
        Matcher m = p.matcher(str);
        if (!m.matches()) {
            throw new IllegalStateException("Can't compile string '" + str + "'");
        }
        String fullName = m.group(1);
        String propertyPath = fullName.substring((parameterName = m.group(2)).length() + 1);
        if (!propertyPath.isEmpty()) {
            propertyPath = propertyPath.substring(1);
        }
        this.bindingParameter = BindingParameter.create(parameterName, propertyPath, null);
    }

    @Override
    public BindingParameter getBindingParameter() {
        return this.bindingParameter;
    }

    @Override
    public void setBindingParameter(BindingParameter bindingParameter) {
        this.bindingParameter = bindingParameter;
    }

    @Override
    public boolean render(InvocationContext context) {
        if (this.bindingParameterInvoker == null) {
            throw new NullPointerException("invoker chain must set");
        }
        Object obj = context.getBindingValue(this.bindingParameterInvoker);
        context.writeToSqlBuffer(obj.toString());
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + "{fullName=" + this.getFullName() + ", parameterName=" + this.bindingParameter.getParameterName() + ", propertyPath=" + this.bindingParameter.getPropertyPath() + "}";
    }

    @Override
    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public String getFullName() {
        return this.bindingParameter.getFullName();
    }

    @Override
    public void setBindingParameterInvoker(BindingParameterInvoker bindingParameterInvoker) {
        this.bindingParameterInvoker = bindingParameterInvoker;
    }
}

