/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.plugin.page;

import java.util.List;
import javax.sql.DataSource;
import org.jfaster.mango.binding.BoundSql;
import org.jfaster.mango.interceptor.Parameter;
import org.jfaster.mango.interceptor.QueryInterceptor;
import org.jfaster.mango.mapper.SingleColumnRowMapper;
import org.jfaster.mango.plugin.page.Page;
import org.jfaster.mango.plugin.page.PageException;

public abstract class AbstractPageInterceptor
extends QueryInterceptor {
    @Override
    public void interceptQuery(BoundSql boundSql, List<Parameter> parameters, DataSource dataSource) {
        for (Parameter parameter : parameters) {
            if (!Page.class.equals(parameter.getRawType())) continue;
            Object val = parameter.getValue();
            if (val == null) {
                throw new PageException("Parameter page is null");
            }
            Page page = (Page)val;
            int pageNum = page.getPageNum();
            int pageSize = page.getPageSize();
            if (pageNum < 0) {
                throw new PageException("pageNum need >= 0, but pageNum is " + pageNum);
            }
            if (pageSize <= 0) {
                throw new PageException("pageSize need > 0, but pageSize is " + pageSize);
            }
            if (page.isFetchTotal()) {
                BoundSql totalBoundSql = boundSql.copy();
                this.handleTotal(totalBoundSql);
                SingleColumnRowMapper<Integer> mapper = new SingleColumnRowMapper<Integer>(Integer.TYPE);
                int total = this.getJdbcOperations().queryForObject(dataSource, totalBoundSql, mapper);
                page.setTotal(total);
            }
            this.handlePage(pageNum, pageSize, boundSql);
        }
    }

    abstract void handleTotal(BoundSql var1);

    abstract void handlePage(int var1, int var2, BoundSql var3);
}

