/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.plugin.page;

import org.jfaster.mango.plugin.page.PageException;

public class Page {
    private static final int DEFAULT_PAGE_NUM = 0;
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final boolean DEFAULT_IS_FETCH_TOTAL = false;
    private final int pageNum;
    private final int pageSize;
    private final boolean isFetchTotal;
    private int total;

    private Page(int pageNum, int pageSize, boolean isFetchTotal) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.isFetchTotal = isFetchTotal;
    }

    public static Page create(int pageNum, int pageSize, boolean isFetchTotal) {
        return new Page(pageNum, pageSize, isFetchTotal);
    }

    public static Page create(int pageNum, int pageSize) {
        return Page.create(pageNum, pageSize, false);
    }

    public static Page create() {
        return Page.create(0, 20);
    }

    public static Page create(boolean isFetchTotal) {
        return new Page(0, 20, isFetchTotal);
    }

    public boolean isFetchTotal() {
        return this.isFetchTotal;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotal() {
        if (!this.isFetchTotal) {
            throw new PageException("can't fetch total, please set isFetchTotal to true");
        }
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }
}

