/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.plugin.stats;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jfaster.mango.annotation.DB;
import org.jfaster.mango.annotation.Sharding;
import org.jfaster.mango.sharding.NotUseTableShardingStrategy;
import org.jfaster.mango.stat.OperatorStat;
import org.jfaster.mango.util.Strings;
import org.jfaster.mango.util.ToStringHelper;

public class ExtendStat {
    private OperatorStat operatorStat;
    private Method method;

    public ExtendStat(OperatorStat operatorStat) {
        this.operatorStat = operatorStat;
        this.method = operatorStat.getMethod();
    }

    public String getSimpleClassName() {
        return this.operatorStat.getDaoClass().getSimpleName();
    }

    public String getSimpleMethodName() {
        return this.method.getName() + "(" + this.method.getParameterTypes().length + ")";
    }

    public String getSql() {
        String sql = this.operatorStat.getSql();
        DB dbAnno = this.operatorStat.getDaoClass().getAnnotation(DB.class);
        String table = dbAnno.table();
        if (Strings.isNotEmpty(table)) {
            Sharding shardingAnno = this.method.getAnnotation(Sharding.class);
            if (shardingAnno == null) {
                shardingAnno = this.operatorStat.getDaoClass().getAnnotation(Sharding.class);
            }
            if (shardingAnno != null && !NotUseTableShardingStrategy.class.equals(shardingAnno.tableShardingStrategy())) {
                table = table + "_#";
            }
            sql = sql.replaceAll("#table", table);
        }
        return sql;
    }

    public List<String> getStrParameterTypes() {
        ArrayList<String> r = new ArrayList<String>();
        for (Type type : this.method.getGenericParameterTypes()) {
            r.add(ToStringHelper.toString(type));
        }
        return r;
    }

    public String getType() {
        return this.operatorStat.getOperatorType().name().toLowerCase();
    }
}

