/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.plugin.stats;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jfaster.mango.operator.Mango;
import org.jfaster.mango.plugin.stats.ExtendStat;
import org.jfaster.mango.plugin.stats.Template;
import org.jfaster.mango.stat.OperatorStat;
import org.jfaster.mango.stat.StatInfo;

public class StatsRender {
    public static String getHtml(boolean isFetchAll) throws Exception {
        List<Mango> mangos = Mango.getInstances();
        if (mangos.size() != 1) {
            throw new IllegalStateException("instance of mango expected 1 but " + mangos.size());
        }
        Mango mango = mangos.get(0);
        HashMap<String, OperatorStat> osMap = new HashMap<String, OperatorStat>();
        HashMap<String, ExtendStat> esMap = new HashMap<String, ExtendStat>();
        StatInfo info = mango.getStatInfo();
        int index = 0;
        for (OperatorStat os : info.getStats()) {
            osMap.put(String.valueOf(index), os);
            esMap.put(String.valueOf(index), new ExtendStat(os));
            ++index;
        }
        String html = Template.render(StatsRender.format(info.getStatBeginTime()), StatsRender.format(info.getStatEndTime()), osMap, esMap, isFetchAll);
        return html;
    }

    private static String format(long time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date(time));
    }
}

