/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.stat;

import org.jfaster.mango.stat.InvocationStat;
import org.jfaster.mango.stat.atomic.LongAddable;
import org.jfaster.mango.stat.atomic.LongAddables;

public class ExecuteStat {
    private final LongAddable databaseExecuteSuccessCount = LongAddables.create();
    private final LongAddable databaseExecuteExceptionCount = LongAddables.create();
    private final LongAddable totalDatabaseExecuteTime = LongAddables.create();
    private final LongAddable hitCount = LongAddables.create();
    private final LongAddable missCount = LongAddables.create();
    private final LongAddable cacheGetSuccessCount = LongAddables.create();
    private final LongAddable cacheGetExceptionCount = LongAddables.create();
    private final LongAddable totalCacheGetTime = LongAddables.create();
    private final LongAddable cacheGetBulkSuccessCount = LongAddables.create();
    private final LongAddable cacheGetBulkExceptionCount = LongAddables.create();
    private final LongAddable totalCacheGetBulkTime = LongAddables.create();
    private final LongAddable cacheSetSuccessCount = LongAddables.create();
    private final LongAddable cacheSetExceptionCount = LongAddables.create();
    private final LongAddable totalCacheSetTime = LongAddables.create();
    private final LongAddable cacheAddSuccessCount = LongAddables.create();
    private final LongAddable cacheAddExceptionCount = LongAddables.create();
    private final LongAddable totalCacheAddTime = LongAddables.create();
    private final LongAddable cacheDeleteSuccessCount = LongAddables.create();
    private final LongAddable cacheDeleteExceptionCount = LongAddables.create();
    private final LongAddable totalCacheDeleteTime = LongAddables.create();
    private final LongAddable cacheBatchDeleteSuccessCount = LongAddables.create();
    private final LongAddable cacheBatchDeleteExceptionCount = LongAddables.create();
    private final LongAddable totalCacheBatchDeleteTime = LongAddables.create();

    private ExecuteStat() {
    }

    public static ExecuteStat create() {
        return new ExecuteStat();
    }

    public void accumulate(InvocationStat stat) {
        this.handleDatabaseExecute(stat);
        this.handleGetAndMiss(stat);
        this.handleCacheGet(stat);
        this.handleCacheGetBulk(stat);
        this.handleCacheSet(stat);
        this.handleCacheAdd(stat);
        this.handleCacheDelete(stat);
        this.handleCacheBatchDelete(stat);
    }

    private void handleDatabaseExecute(InvocationStat stat) {
        if (stat.getDatabaseExecuteSuccessCount() > 0L) {
            this.databaseExecuteSuccessCount.add(stat.getDatabaseExecuteSuccessCount());
        }
        if (stat.getDatabaseExecuteExceptionCount() > 0L) {
            this.databaseExecuteExceptionCount.add(stat.getDatabaseExecuteExceptionCount());
        }
        if (stat.getTotalDatabaseExecuteTime() > 0L) {
            this.totalDatabaseExecuteTime.add(stat.getTotalDatabaseExecuteTime());
        }
    }

    private void handleGetAndMiss(InvocationStat stat) {
        if (stat.getHitCount() > 0L) {
            this.hitCount.add(stat.getHitCount());
        }
        if (stat.getMissCount() > 0L) {
            this.missCount.add(stat.getMissCount());
        }
    }

    private void handleCacheGet(InvocationStat stat) {
        if (stat.getCacheGetSuccessCount() > 0L) {
            this.cacheGetSuccessCount.add(stat.getCacheGetSuccessCount());
        }
        if (stat.getCacheGetExceptionCount() > 0L) {
            this.cacheGetExceptionCount.add(stat.getCacheGetExceptionCount());
        }
        if (stat.getTotalCacheGetTime() > 0L) {
            this.totalCacheGetTime.add(stat.getTotalCacheGetTime());
        }
    }

    private void handleCacheGetBulk(InvocationStat stat) {
        if (stat.getCacheGetBulkSuccessCount() > 0L) {
            this.cacheGetBulkSuccessCount.add(stat.getCacheGetBulkSuccessCount());
        }
        if (stat.getCacheGetBulkExceptionCount() > 0L) {
            this.cacheGetBulkExceptionCount.add(stat.getCacheGetBulkExceptionCount());
        }
        if (stat.getTotalCacheGetBulkTime() > 0L) {
            this.totalCacheGetBulkTime.add(stat.getTotalCacheGetBulkTime());
        }
    }

    private void handleCacheSet(InvocationStat stat) {
        if (stat.getCacheSetSuccessCount() > 0L) {
            this.cacheSetSuccessCount.add(stat.getCacheSetSuccessCount());
        }
        if (stat.getCacheSetExceptionCount() > 0L) {
            this.cacheSetExceptionCount.add(stat.getCacheSetExceptionCount());
        }
        if (stat.getTotalCacheSetTime() > 0L) {
            this.totalCacheSetTime.add(stat.getTotalCacheSetTime());
        }
    }

    private void handleCacheAdd(InvocationStat stat) {
        if (stat.getCacheAddSuccessCount() > 0L) {
            this.cacheAddSuccessCount.add(stat.getCacheAddSuccessCount());
        }
        if (stat.getCacheAddExceptionCount() > 0L) {
            this.cacheAddExceptionCount.add(stat.getCacheAddExceptionCount());
        }
        if (stat.getTotalCacheAddTime() > 0L) {
            this.totalCacheAddTime.add(stat.getTotalCacheAddTime());
        }
    }

    private void handleCacheDelete(InvocationStat stat) {
        if (stat.getCacheDeleteSuccessCount() > 0L) {
            this.cacheDeleteSuccessCount.add(stat.getCacheDeleteSuccessCount());
        }
        if (stat.getCacheDeleteExceptionCount() > 0L) {
            this.cacheDeleteExceptionCount.add(stat.getCacheDeleteExceptionCount());
        }
        if (stat.getTotalCacheDeleteTime() > 0L) {
            this.totalCacheDeleteTime.add(stat.getTotalCacheDeleteTime());
        }
    }

    private void handleCacheBatchDelete(InvocationStat stat) {
        if (stat.getCacheBatchDeleteSuccessCount() > 0L) {
            this.cacheBatchDeleteSuccessCount.add(stat.getCacheBatchDeleteSuccessCount());
        }
        if (stat.getCacheBatchDeleteExceptionCount() > 0L) {
            this.cacheBatchDeleteExceptionCount.add(stat.getCacheBatchDeleteExceptionCount());
        }
        if (stat.getTotalCacheBatchDeleteTime() > 0L) {
            this.totalCacheBatchDeleteTime.add(stat.getTotalCacheBatchDeleteTime());
        }
    }

    public long getDatabaseExecuteSuccessCount() {
        return this.databaseExecuteSuccessCount.sum();
    }

    public long getDatabaseExecuteExceptionCount() {
        return this.databaseExecuteExceptionCount.sum();
    }

    public long getTotalDatabaseExecuteTime() {
        return this.totalDatabaseExecuteTime.sum();
    }

    public long getHitCount() {
        return this.hitCount.sum();
    }

    public long getMissCount() {
        return this.missCount.sum();
    }

    public long getCacheGetSuccessCount() {
        return this.cacheGetSuccessCount.sum();
    }

    public long getCacheGetExceptionCount() {
        return this.cacheGetExceptionCount.sum();
    }

    public long getTotalCacheGetTime() {
        return this.totalCacheGetTime.sum();
    }

    public long getCacheGetBulkSuccessCount() {
        return this.cacheGetBulkSuccessCount.sum();
    }

    public long getCacheGetBulkExceptionCount() {
        return this.cacheGetBulkExceptionCount.sum();
    }

    public long getTotalCacheGetBulkTime() {
        return this.totalCacheGetBulkTime.sum();
    }

    public long getCacheSetSuccessCount() {
        return this.cacheSetSuccessCount.sum();
    }

    public long getCacheSetExceptionCount() {
        return this.cacheSetExceptionCount.sum();
    }

    public long getTotalCacheSetTime() {
        return this.totalCacheSetTime.sum();
    }

    public long getCacheAddSuccessCount() {
        return this.cacheAddSuccessCount.sum();
    }

    public long getCacheAddExceptionCount() {
        return this.cacheAddExceptionCount.sum();
    }

    public long getTotalCacheAddTime() {
        return this.totalCacheAddTime.sum();
    }

    public long getCacheDeleteSuccessCount() {
        return this.cacheDeleteSuccessCount.sum();
    }

    public long getCacheDeleteExceptionCount() {
        return this.cacheDeleteExceptionCount.sum();
    }

    public long getTotalCacheDeleteTime() {
        return this.totalCacheDeleteTime.sum();
    }

    public long getCacheBatchDeleteSuccessCount() {
        return this.cacheBatchDeleteSuccessCount.sum();
    }

    public long getCacheBatchDeleteExceptionCount() {
        return this.cacheBatchDeleteExceptionCount.sum();
    }

    public long getTotalCacheBatchDeleteTime() {
        return this.totalCacheBatchDeleteTime.sum();
    }
}

