/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.stat;

public class InvocationStat {
    private long databaseExecuteSuccessCount;
    private long databaseExecuteExceptionCount;
    private long totalDatabaseExecuteTime;
    private long hitCount;
    private long missCount;
    private long cacheGetSuccessCount;
    private long cacheGetExceptionCount;
    private long totalCacheGetTime;
    private long cacheGetBulkSuccessCount;
    private long cacheGetBulkExceptionCount;
    private long totalCacheGetBulkTime;
    private long cacheSetSuccessCount;
    private long cacheSetExceptionCount;
    private long totalCacheSetTime;
    private long cacheAddSuccessCount;
    private long cacheAddExceptionCount;
    private long totalCacheAddTime;
    private long cacheDeleteSuccessCount;
    private long cacheDeleteExceptionCount;
    private long totalCacheDeleteTime;
    private long cacheBatchDeleteSuccessCount;
    private long cacheBatchDeleteExceptionCount;
    private long totalCacheBatchDeleteTime;

    private InvocationStat() {
    }

    public static InvocationStat create() {
        return new InvocationStat();
    }

    public void recordDatabaseExecuteSuccess(long executeTime) {
        if (executeTime >= 0L) {
            ++this.databaseExecuteSuccessCount;
            this.totalDatabaseExecuteTime += executeTime;
        }
    }

    public void recordDatabaseExecuteException(long executeTime) {
        if (executeTime >= 0L) {
            ++this.databaseExecuteExceptionCount;
            this.totalDatabaseExecuteTime += executeTime;
        }
    }

    public void recordHits(int count) {
        if (count > 0) {
            this.hitCount += (long)count;
        }
    }

    public void recordMisses(int count) {
        if (count > 0) {
            this.missCount += (long)count;
        }
    }

    public void recordCacheGetSuccess(long executeTime) {
        if (executeTime >= 0L) {
            ++this.cacheGetSuccessCount;
            this.totalCacheGetTime += executeTime;
        }
    }

    public void recordCacheGetException(long executeTime) {
        if (executeTime >= 0L) {
            ++this.cacheGetExceptionCount;
            this.totalCacheGetTime += executeTime;
        }
    }

    public void recordCacheGetBulkSuccess(long executeTime) {
        if (executeTime >= 0L) {
            ++this.cacheGetBulkSuccessCount;
            this.totalCacheGetBulkTime += executeTime;
        }
    }

    public void recordCacheGetBulkException(long executeTime) {
        if (executeTime >= 0L) {
            ++this.cacheGetBulkExceptionCount;
            this.totalCacheGetBulkTime += executeTime;
        }
    }

    public void recordCacheSetSuccess(long executeTime) {
        if (executeTime >= 0L) {
            ++this.cacheSetSuccessCount;
            this.totalCacheSetTime += executeTime;
        }
    }

    public void recordCacheSetException(long executeTime) {
        if (executeTime >= 0L) {
            ++this.cacheSetExceptionCount;
            this.totalCacheSetTime += executeTime;
        }
    }

    public void recordCacheAddSuccess(long executeTime) {
        if (executeTime >= 0L) {
            ++this.cacheAddSuccessCount;
            this.totalCacheAddTime += executeTime;
        }
    }

    public void recordCacheAddException(long executeTime) {
        if (executeTime >= 0L) {
            ++this.cacheAddExceptionCount;
            this.totalCacheAddTime += executeTime;
        }
    }

    public void recordCacheDeleteSuccess(long executeTime) {
        if (executeTime >= 0L) {
            ++this.cacheDeleteSuccessCount;
            this.totalCacheDeleteTime += executeTime;
        }
    }

    public void recordCacheDeleteException(long executeTime) {
        if (executeTime >= 0L) {
            ++this.cacheDeleteExceptionCount;
            this.totalCacheDeleteTime += executeTime;
        }
    }

    public void recordCacheBatchDeleteSuccess(long executeTime) {
        if (executeTime >= 0L) {
            ++this.cacheBatchDeleteSuccessCount;
            this.totalCacheBatchDeleteTime += executeTime;
        }
    }

    public void recordCacheBatchDeleteException(long executeTime) {
        if (executeTime >= 0L) {
            ++this.cacheBatchDeleteExceptionCount;
            this.totalCacheBatchDeleteTime += executeTime;
        }
    }

    public long getDatabaseExecuteSuccessCount() {
        return this.databaseExecuteSuccessCount;
    }

    public long getDatabaseExecuteExceptionCount() {
        return this.databaseExecuteExceptionCount;
    }

    public long getTotalDatabaseExecuteTime() {
        return this.totalDatabaseExecuteTime;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public long getCacheGetSuccessCount() {
        return this.cacheGetSuccessCount;
    }

    public long getCacheGetExceptionCount() {
        return this.cacheGetExceptionCount;
    }

    public long getTotalCacheGetTime() {
        return this.totalCacheGetTime;
    }

    public long getCacheGetBulkSuccessCount() {
        return this.cacheGetBulkSuccessCount;
    }

    public long getCacheGetBulkExceptionCount() {
        return this.cacheGetBulkExceptionCount;
    }

    public long getTotalCacheGetBulkTime() {
        return this.totalCacheGetBulkTime;
    }

    public long getCacheSetSuccessCount() {
        return this.cacheSetSuccessCount;
    }

    public long getCacheSetExceptionCount() {
        return this.cacheSetExceptionCount;
    }

    public long getTotalCacheSetTime() {
        return this.totalCacheSetTime;
    }

    public long getCacheAddSuccessCount() {
        return this.cacheAddSuccessCount;
    }

    public long getCacheAddExceptionCount() {
        return this.cacheAddExceptionCount;
    }

    public long getTotalCacheAddTime() {
        return this.totalCacheAddTime;
    }

    public long getCacheDeleteSuccessCount() {
        return this.cacheDeleteSuccessCount;
    }

    public long getCacheDeleteExceptionCount() {
        return this.cacheDeleteExceptionCount;
    }

    public long getTotalCacheDeleteTime() {
        return this.totalCacheDeleteTime;
    }

    public long getCacheBatchDeleteSuccessCount() {
        return this.cacheBatchDeleteSuccessCount;
    }

    public long getCacheBatchDeleteExceptionCount() {
        return this.cacheBatchDeleteExceptionCount;
    }

    public long getTotalCacheBatchDeleteTime() {
        return this.totalCacheBatchDeleteTime;
    }
}

