/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.stat;

import java.lang.reflect.Method;
import org.jfaster.mango.util.jdbc.OperatorType;

public class OperatorStat {
    private final Class<?> daoClass;
    private final Method method;
    private final String sql;
    private final OperatorType operatorType;
    private final boolean isCacheable;
    private final boolean isUseMultipleKeys;
    private boolean isCacheNullObject;
    private final long initCount;
    private final long totalInitTime;
    private final long databaseExecuteSuccessCount;
    private final long databaseExecuteExceptionCount;
    private final long totalDatabaseExecuteTime;
    private final long hitCount;
    private final long missCount;
    private final long cacheGetSuccessCount;
    private final long cacheGetExceptionCount;
    private final long totalCacheGetTime;
    private final long cacheGetBulkSuccessCount;
    private final long cacheGetBulkExceptionCount;
    private final long totalCacheGetBulkTime;
    private final long cacheSetSuccessCount;
    private final long cacheSetExceptionCount;
    private final long totalCacheSetTime;
    private final long cacheAddSuccessCount;
    private final long cacheAddExceptionCount;
    private final long totalCacheAddTime;
    private final long cacheDeleteSuccessCount;
    private final long cacheDeleteExceptionCount;
    private final long totalCacheDeleteTime;
    private final long cacheBatchDeleteSuccessCount;
    private final long cacheBatchDeleteExceptionCount;
    private final long totalCacheBatchDeleteTime;

    public OperatorStat(Class<?> daoClass, Method method, String sql, OperatorType operatorType, boolean isCacheable, boolean isUseMultipleKeys, boolean isCacheNullObject, long initCount, long totalInitTime, long databaseExecuteSuccessCount, long databaseExecuteExceptionCount, long totalDatabaseExecuteTime, long hitCount, long missCount, long cacheGetSuccessCount, long cacheGetExceptionCount, long totalCacheGetTime, long cacheGetBulkSuccessCount, long cacheGetBulkExceptionCount, long totalCacheGetBulkTime, long cacheSetSuccessCount, long cacheSetExceptionCount, long totalCacheSetTime, long cacheAddSuccessCount, long cacheAddExceptionCount, long totalCacheAddTime, long cacheDeleteSuccessCount, long cacheDeleteExceptionCount, long totalCacheDeleteTime, long cacheBatchDeleteSuccessCount, long cacheBatchDeleteExceptionCount, long totalCacheBatchDeleteTime) {
        this.daoClass = daoClass;
        this.method = method;
        this.sql = sql;
        this.operatorType = operatorType;
        this.isCacheable = isCacheable;
        this.isUseMultipleKeys = isUseMultipleKeys;
        this.isCacheNullObject = isCacheNullObject;
        this.initCount = initCount;
        this.totalInitTime = totalInitTime;
        this.databaseExecuteSuccessCount = databaseExecuteSuccessCount;
        this.databaseExecuteExceptionCount = databaseExecuteExceptionCount;
        this.totalDatabaseExecuteTime = totalDatabaseExecuteTime;
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.cacheGetSuccessCount = cacheGetSuccessCount;
        this.cacheGetExceptionCount = cacheGetExceptionCount;
        this.totalCacheGetTime = totalCacheGetTime;
        this.cacheGetBulkSuccessCount = cacheGetBulkSuccessCount;
        this.cacheGetBulkExceptionCount = cacheGetBulkExceptionCount;
        this.totalCacheGetBulkTime = totalCacheGetBulkTime;
        this.cacheSetSuccessCount = cacheSetSuccessCount;
        this.cacheSetExceptionCount = cacheSetExceptionCount;
        this.totalCacheSetTime = totalCacheSetTime;
        this.cacheAddSuccessCount = cacheAddSuccessCount;
        this.cacheAddExceptionCount = cacheAddExceptionCount;
        this.totalCacheAddTime = totalCacheAddTime;
        this.cacheDeleteSuccessCount = cacheDeleteSuccessCount;
        this.cacheDeleteExceptionCount = cacheDeleteExceptionCount;
        this.totalCacheDeleteTime = totalCacheDeleteTime;
        this.cacheBatchDeleteSuccessCount = cacheBatchDeleteSuccessCount;
        this.cacheBatchDeleteExceptionCount = cacheBatchDeleteExceptionCount;
        this.totalCacheBatchDeleteTime = totalCacheBatchDeleteTime;
    }

    public Class<?> getDaoClass() {
        return this.daoClass;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getSql() {
        return this.sql;
    }

    public OperatorType getOperatorType() {
        return this.operatorType;
    }

    public boolean isCacheable() {
        return this.isCacheable;
    }

    public boolean isUseMultipleKeys() {
        return this.isUseMultipleKeys;
    }

    public boolean isCacheNullObject() {
        return this.isCacheNullObject;
    }

    public long getInitCount() {
        return this.initCount;
    }

    public long getTotalInitTime() {
        return this.totalInitTime;
    }

    public long getInitAveragePenalty() {
        return this.initCount == 0L ? 0L : this.totalInitTime / this.initCount;
    }

    public long getDatabaseExecuteSuccessCount() {
        return this.databaseExecuteSuccessCount;
    }

    public long getDatabaseExecuteExceptionCount() {
        return this.databaseExecuteExceptionCount;
    }

    public long getTotalDatabaseExecuteTime() {
        return this.totalDatabaseExecuteTime;
    }

    public long getDatabaseExecuteCount() {
        return this.databaseExecuteSuccessCount + this.databaseExecuteExceptionCount;
    }

    public double getDatabaseExecuteSuccessRate() {
        long totalDatabaseExecuteCount = this.getDatabaseExecuteCount();
        return totalDatabaseExecuteCount == 0L ? 1.0 : (double)this.databaseExecuteSuccessCount / (double)totalDatabaseExecuteCount;
    }

    public double getDatabaseExecuteExceptionRate() {
        long totalDatabaseExecuteCount = this.getDatabaseExecuteCount();
        return totalDatabaseExecuteCount == 0L ? 0.0 : (double)this.databaseExecuteExceptionCount / (double)totalDatabaseExecuteCount;
    }

    public long getDatabaseExecuteAveragePenalty() {
        long totalDatabaseExecuteCount = this.getDatabaseExecuteCount();
        return totalDatabaseExecuteCount == 0L ? 0L : this.totalDatabaseExecuteTime / totalDatabaseExecuteCount;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public long getMissCount() {
        return this.missCount;
    }

    public double getHitRate() {
        long requestCount = this.hitCount + this.missCount;
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    public long getCacheGetSuccessCount() {
        return this.cacheGetSuccessCount;
    }

    public long getCacheGetExceptionCount() {
        return this.cacheGetExceptionCount;
    }

    public long getTotalCacheGetTime() {
        return this.totalCacheGetTime;
    }

    public long getCacheGetCount() {
        return this.cacheGetSuccessCount + this.cacheGetExceptionCount;
    }

    public double getCacheGetSuccessRate() {
        long totalCacheGetCount = this.getCacheGetCount();
        return totalCacheGetCount == 0L ? 1.0 : (double)this.cacheGetSuccessCount / (double)totalCacheGetCount;
    }

    public double getCacheGetExceptionRate() {
        long totalCacheGetCount = this.getCacheGetCount();
        return totalCacheGetCount == 0L ? 0.0 : (double)this.cacheGetExceptionCount / (double)totalCacheGetCount;
    }

    public long getCacheGetAveragePenalty() {
        long totalCacheGetCount = this.getCacheGetCount();
        return totalCacheGetCount == 0L ? 0L : this.totalCacheGetTime / totalCacheGetCount;
    }

    public long getCacheGetBulkSuccessCount() {
        return this.cacheGetBulkSuccessCount;
    }

    public long getCacheGetBulkExceptionCount() {
        return this.cacheGetBulkExceptionCount;
    }

    public long getTotalCacheGetBulkTime() {
        return this.totalCacheGetBulkTime;
    }

    public long getCacheGetBulkCount() {
        return this.cacheGetBulkSuccessCount + this.cacheGetBulkExceptionCount;
    }

    public double getCacheGetBulkSuccessRate() {
        long totalCacheGetBulkCount = this.getCacheGetBulkCount();
        return totalCacheGetBulkCount == 0L ? 1.0 : (double)this.cacheGetBulkSuccessCount / (double)totalCacheGetBulkCount;
    }

    public double getCacheGetBulkExceptionRate() {
        long totalCacheGetBulkCount = this.getCacheGetBulkCount();
        return totalCacheGetBulkCount == 0L ? 0.0 : (double)this.cacheGetBulkExceptionCount / (double)totalCacheGetBulkCount;
    }

    public long getCacheGetBulkAveragePenalty() {
        long totalCacheGetBulkCount = this.getCacheGetBulkCount();
        return totalCacheGetBulkCount == 0L ? 0L : this.totalCacheGetBulkTime / totalCacheGetBulkCount;
    }

    public long getCacheSetSuccessCount() {
        return this.cacheSetSuccessCount;
    }

    public long getCacheSetExceptionCount() {
        return this.cacheSetExceptionCount;
    }

    public long getTotalCacheSetTime() {
        return this.totalCacheSetTime;
    }

    public long getCacheSetCount() {
        return this.cacheSetSuccessCount + this.cacheSetExceptionCount;
    }

    public double getCacheSetSuccessRate() {
        long totalCacheSetCount = this.getCacheSetCount();
        return totalCacheSetCount == 0L ? 1.0 : (double)this.cacheSetSuccessCount / (double)totalCacheSetCount;
    }

    public double getCacheSetExceptionRate() {
        long totalCacheSetCount = this.getCacheSetCount();
        return totalCacheSetCount == 0L ? 0.0 : (double)this.cacheSetExceptionCount / (double)totalCacheSetCount;
    }

    public long getCacheSetAveragePenalty() {
        long totalCacheSetCount = this.getCacheSetCount();
        return totalCacheSetCount == 0L ? 0L : this.totalCacheSetTime / totalCacheSetCount;
    }

    public long getCacheAddSuccessCount() {
        return this.cacheAddSuccessCount;
    }

    public long getCacheAddExceptionCount() {
        return this.cacheAddExceptionCount;
    }

    public long getTotalCacheAddTime() {
        return this.totalCacheAddTime;
    }

    public long getCacheAddCount() {
        return this.cacheAddSuccessCount + this.cacheAddExceptionCount;
    }

    public double getCacheAddSuccessRate() {
        long totalCacheAddCount = this.getCacheAddCount();
        return totalCacheAddCount == 0L ? 1.0 : (double)this.cacheAddSuccessCount / (double)totalCacheAddCount;
    }

    public double getCacheAddExceptionRate() {
        long totalCacheAddCount = this.getCacheAddCount();
        return totalCacheAddCount == 0L ? 0.0 : (double)this.cacheAddExceptionCount / (double)totalCacheAddCount;
    }

    public long getCacheAddAveragePenalty() {
        long totalCacheAddCount = this.getCacheAddCount();
        return totalCacheAddCount == 0L ? 0L : this.totalCacheAddTime / totalCacheAddCount;
    }

    public long getCacheDeleteSuccessCount() {
        return this.cacheDeleteSuccessCount;
    }

    public long getCacheDeleteExceptionCount() {
        return this.cacheDeleteExceptionCount;
    }

    public long getTotalCacheDeleteTime() {
        return this.totalCacheDeleteTime;
    }

    public long getCacheDeleteCount() {
        return this.cacheDeleteSuccessCount + this.cacheDeleteExceptionCount;
    }

    public double getCacheDeleteSuccessRate() {
        long totalCacheDeleteCount = this.getCacheDeleteCount();
        return totalCacheDeleteCount == 0L ? 1.0 : (double)this.cacheDeleteSuccessCount / (double)totalCacheDeleteCount;
    }

    public double getCacheDeleteExceptionRate() {
        long totalCacheDeleteCount = this.getCacheDeleteCount();
        return totalCacheDeleteCount == 0L ? 0.0 : (double)this.cacheDeleteExceptionCount / (double)totalCacheDeleteCount;
    }

    public long getCacheDeleteAveragePenalty() {
        long totalCacheDeleteCount = this.getCacheDeleteCount();
        return totalCacheDeleteCount == 0L ? 0L : this.totalCacheDeleteTime / totalCacheDeleteCount;
    }

    public long getCacheBatchDeleteSuccessCount() {
        return this.cacheBatchDeleteSuccessCount;
    }

    public long getCacheBatchDeleteExceptionCount() {
        return this.cacheBatchDeleteExceptionCount;
    }

    public long getTotalCacheBatchDeleteTime() {
        return this.totalCacheBatchDeleteTime;
    }

    public long getCacheBatchDeleteCount() {
        return this.cacheBatchDeleteSuccessCount + this.cacheBatchDeleteExceptionCount;
    }

    public double getCacheBatchDeleteSuccessRate() {
        long totalCacheBatchDeleteCount = this.getCacheBatchDeleteCount();
        return totalCacheBatchDeleteCount == 0L ? 1.0 : (double)this.cacheBatchDeleteSuccessCount / (double)totalCacheBatchDeleteCount;
    }

    public double getCacheBatchDeleteExceptionRate() {
        long totalCacheBatchDeleteCount = this.getCacheBatchDeleteCount();
        return totalCacheBatchDeleteCount == 0L ? 0.0 : (double)this.cacheBatchDeleteExceptionCount / (double)totalCacheBatchDeleteCount;
    }

    public long getCacheBatchDeleteAveragePenalty() {
        long totalCacheBatchDeleteCount = this.getCacheBatchDeleteCount();
        return totalCacheBatchDeleteCount == 0L ? 0L : this.totalCacheBatchDeleteTime / totalCacheBatchDeleteCount;
    }
}

