/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.stat;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jfaster.mango.stat.OperatorStat;
import org.jfaster.mango.stat.StatMonitor;

public class SimpleStatMonitor
implements StatMonitor {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final int DEFAULT_PERIOD_SECOND = 10;
    private int periodSecond;

    public SimpleStatMonitor() {
        this(10);
    }

    public SimpleStatMonitor(int periodSecond) {
        this.periodSecond = periodSecond;
    }

    @Override
    public void handleStat(long statBeginTime, long statEndTime, List<OperatorStat> stats) throws Exception {
        StringBuilder data = new StringBuilder();
        data.append("Performance Statistics  [").append(this.format(statBeginTime)).append("] - [").append(this.format(statEndTime)).append("]").append(NEWLINE);
        data.append(String.format("%-36s%-12s%-12s%-12s%n", "dao", "avg", "total", "error"));
        for (OperatorStat stat : stats) {
            if (stat.getDatabaseExecuteCount() <= 0L) continue;
            String dao = stat.getMethod().getDeclaringClass().getSimpleName() + "." + stat.getMethod().getName();
            data.append(String.format("%-36s%-12.1f%-12s%-12s%n", dao, (double)stat.getDatabaseExecuteAveragePenalty() / 1000000.0, stat.getDatabaseExecuteCount(), stat.getDatabaseExecuteExceptionCount()));
        }
        System.out.println(data);
    }

    @Override
    public int periodSecond() {
        return this.periodSecond;
    }

    private String format(long time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date(time));
    }

    public void setPeriodSecond(int periodSecond) {
        this.periodSecond = periodSecond;
    }
}

