/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.stat;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jfaster.mango.stat.CombinedStat;
import org.jfaster.mango.stat.ExecuteStat;
import org.jfaster.mango.stat.OperatorStat;
import org.jfaster.mango.stat.StatInfo;
import org.jfaster.mango.stat.StatMonitor;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public class StatCollector {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(StatCollector.class);
    private final ConcurrentHashMap<Method, CombinedStat> combinedStatMap = new ConcurrentHashMap();
    private long timestamp = this.currentTimeMillis();
    private ScheduledExecutorService scheduler;
    private ExecutorService worker;

    public synchronized void initStatMonitor(final StatMonitor statMonitor) {
        if (this.scheduler != null) {
            throw new IllegalStateException("StatMonitor is initialized many times");
        }
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.worker = Executors.newSingleThreadExecutor();
        long periodSecond = statMonitor.periodSecond();
        long nowSecond = this.currentTimeMillis() / 1000L;
        long delay = nowSecond / periodSecond * periodSecond + periodSecond - nowSecond;
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                final StatInfo statInfo = StatCollector.this.resetAndGetStatInfo();
                StatCollector.this.worker.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            statMonitor.handleStat(statInfo.getStatBeginTime(), statInfo.getStatEndTime(), statInfo.getStats());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error("StatMonitor handle stat error", e);
                        }
                    }
                });
            }
        }, delay, periodSecond, TimeUnit.SECONDS);
    }

    public synchronized void shutDown() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        if (this.worker != null) {
            this.worker.shutdown();
        }
    }

    public synchronized StatInfo getStatInfo() {
        long now = this.currentTimeMillis();
        ArrayList<OperatorStat> operatorStats = new ArrayList<OperatorStat>();
        for (CombinedStat combinedStat : this.combinedStatMap.values()) {
            operatorStats.add(combinedStat.toOperatorStat());
        }
        return StatInfo.create(this.timestamp, now, operatorStats);
    }

    public synchronized StatInfo resetAndGetStatInfo() {
        long now = this.currentTimeMillis();
        ArrayList<CombinedStat> combinedStats = new ArrayList<CombinedStat>();
        for (CombinedStat combinedStat : this.combinedStatMap.values()) {
            ExecuteStat executeStat = combinedStat.getExecuteStat();
            combinedStat.setExecuteStat(ExecuteStat.create());
            combinedStats.add(CombinedStat.create(combinedStat.getMetaStat(), combinedStat.getInitStat(), executeStat));
        }
        try {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ArrayList<OperatorStat> operatorStats = new ArrayList<OperatorStat>();
        for (CombinedStat combinedStat : combinedStats) {
            operatorStats.add(combinedStat.toOperatorStat());
        }
        StatInfo statInfo = StatInfo.create(this.timestamp, now, operatorStats);
        this.timestamp = now;
        return statInfo;
    }

    public CombinedStat getCombinedStat(Method method) {
        CombinedStat old;
        CombinedStat stat = this.combinedStatMap.get(method);
        if (stat == null && (old = this.combinedStatMap.putIfAbsent(method, stat = CombinedStat.create())) != null) {
            stat = old;
        }
        return stat;
    }

    private long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

