/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.stat.atomic;

import java.util.concurrent.atomic.AtomicLong;
import org.jfaster.mango.stat.atomic.LongAddable;
import org.jfaster.mango.stat.atomic.LongAdder;

public final class LongAddables {
    private static final Supplier<LongAddable> SUPPLIER;

    public static LongAddable create() {
        return SUPPLIER.get();
    }

    static {
        Supplier<LongAddable> supplier;
        try {
            new LongAdder();
            supplier = new Supplier<LongAddable>(){

                @Override
                public LongAddable get() {
                    return new LongAdder();
                }
            };
        }
        catch (Throwable t) {
            supplier = new Supplier<LongAddable>(){

                @Override
                public LongAddable get() {
                    return new PureJavaLongAddable();
                }
            };
        }
        SUPPLIER = supplier;
    }

    private static interface Supplier<T> {
        public T get();
    }

    private static final class PureJavaLongAddable
    extends AtomicLong
    implements LongAddable {
        private PureJavaLongAddable() {
        }

        @Override
        public void increment() {
            this.getAndIncrement();
        }

        @Override
        public void add(long x) {
            this.getAndAdd(x);
        }

        @Override
        public long sum() {
            return this.get();
        }
    }
}

