/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.transaction;

import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.jfaster.mango.operator.Mango;
import org.jfaster.mango.transaction.ConnectionHolder;
import org.jfaster.mango.transaction.DataSourceUtils;
import org.jfaster.mango.transaction.Transaction;
import org.jfaster.mango.transaction.TransactionImpl;
import org.jfaster.mango.transaction.TransactionIsolationLevel;
import org.jfaster.mango.transaction.TransactionSynchronizationManager;
import org.jfaster.mango.transaction.exception.CannotCreateTransactionException;
import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.InternalLoggerFactory;

public abstract class TransactionFactory {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(TransactionFactory.class);

    public static Transaction newTransaction(Mango mango, String dataSourceFactoryName, TransactionIsolationLevel level) {
        DataSource dataSource = mango.getMasterDataSource(dataSourceFactoryName);
        if (dataSource == null) {
            throw new IllegalArgumentException("Can't find master DataSource from mango [" + mango + "] with datasource factory name [" + dataSourceFactoryName + "]");
        }
        return TransactionFactory.newTransaction(dataSource, level);
    }

    public static Transaction newTransaction(Mango mango, String dataSourceFactoryName) {
        return TransactionFactory.newTransaction(mango, dataSourceFactoryName, TransactionIsolationLevel.DEFAULT);
    }

    public static Transaction newTransaction(String dataSourceFactoryName, TransactionIsolationLevel level) {
        List<Mango> mangos = Mango.getInstances();
        if (mangos.size() != 1) {
            throw new IllegalStateException("The number of instances mango expected 1 but " + mangos.size() + ", Please specify mango instance");
        }
        return TransactionFactory.newTransaction(mangos.get(0), dataSourceFactoryName, level);
    }

    public static Transaction newTransaction(String dataSourceFactoryName) {
        return TransactionFactory.newTransaction(dataSourceFactoryName, TransactionIsolationLevel.DEFAULT);
    }

    public static Transaction newTransaction(TransactionIsolationLevel level) {
        return TransactionFactory.newTransaction("DEFAULT", level);
    }

    public static Transaction newTransaction() {
        return TransactionFactory.newTransaction("DEFAULT", TransactionIsolationLevel.DEFAULT);
    }

    public static Transaction newTransaction(DataSource dataSource) {
        return TransactionFactory.newTransaction(dataSource, TransactionIsolationLevel.DEFAULT);
    }

    private static Transaction newTransaction(DataSource dataSource, TransactionIsolationLevel level) {
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource can't be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("TransactionIsolationLevel can't be null");
        }
        ConnectionHolder connHolder = TransactionSynchronizationManager.getConnectionHolder(dataSource);
        return connHolder != null ? TransactionFactory.usingExistingTransaction(dataSource) : TransactionFactory.createNewTransaction(dataSource, level);
    }

    private static Transaction usingExistingTransaction(DataSource dataSource) {
        if (logger.isDebugEnabled()) {
            logger.debug("Using existing transaction");
        }
        TransactionImpl transaction = new TransactionImpl(false, dataSource);
        return transaction;
    }

    private static Transaction createNewTransaction(DataSource dataSource, TransactionIsolationLevel expectedLevel) {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating new transaction");
        }
        Connection conn = null;
        try {
            Integer previousLevel = null;
            boolean isMustRestoreAutoCommit = false;
            conn = dataSource.getConnection();
            if (logger.isDebugEnabled()) {
                logger.debug("Acquired Connection [" + conn + "] for JDBC transaction");
            }
            if (expectedLevel != TransactionIsolationLevel.DEFAULT && (previousLevel = Integer.valueOf(conn.getTransactionIsolation())).intValue() != expectedLevel.getLevel()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Changing isolation level of JDBC Connection [" + conn + "] to " + expectedLevel.getLevel());
                }
                conn.setTransactionIsolation(expectedLevel.getLevel());
            }
            if (conn.getAutoCommit()) {
                isMustRestoreAutoCommit = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("Switching JDBC Connection [" + conn + "] to manual commit");
                }
                conn.setAutoCommit(false);
            }
            TransactionImpl transaction = new TransactionImpl(true, dataSource, previousLevel, isMustRestoreAutoCommit);
            ConnectionHolder connHolder = new ConnectionHolder(conn);
            TransactionSynchronizationManager.bindConnectionHolder(dataSource, connHolder);
            return transaction;
        }
        catch (Throwable e) {
            DataSourceUtils.releaseConnection(conn, dataSource);
            throw new CannotCreateTransactionException("Could not open JDBC Connection for transaction", e);
        }
    }
}

