/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.transaction;

import org.jfaster.mango.operator.Mango;
import org.jfaster.mango.transaction.Transaction;
import org.jfaster.mango.transaction.TransactionAction;
import org.jfaster.mango.transaction.TransactionFactory;
import org.jfaster.mango.transaction.TransactionIsolationLevel;
import org.jfaster.mango.transaction.TransactionStatus;
import org.jfaster.mango.transaction.exception.TransactionException;

public class TransactionTemplate {
    public static void execute(Mango mango, String dataSourceFactoryName, TransactionIsolationLevel level, TransactionAction action) throws TransactionException {
        TransactionTemplate.execute(TransactionFactory.newTransaction(mango, dataSourceFactoryName, level), action);
    }

    public static void execute(Mango mango, String dataSourceFactoryName, TransactionAction action) throws TransactionException {
        TransactionTemplate.execute(TransactionFactory.newTransaction(mango, dataSourceFactoryName), action);
    }

    public static void execute(String dataSourceFactoryName, TransactionIsolationLevel level, TransactionAction action) throws TransactionException {
        TransactionTemplate.execute(TransactionFactory.newTransaction(dataSourceFactoryName, level), action);
    }

    public static void execute(String dataSourceFactoryName, TransactionAction action) throws TransactionException {
        TransactionTemplate.execute(TransactionFactory.newTransaction(dataSourceFactoryName), action);
    }

    public static void execute(TransactionIsolationLevel level, TransactionAction action) throws TransactionException {
        TransactionTemplate.execute(TransactionFactory.newTransaction(level), action);
    }

    public static void execute(TransactionAction action) throws TransactionException {
        TransactionTemplate.execute(TransactionFactory.newTransaction(), action);
    }

    private static void execute(Transaction transaction, TransactionAction action) throws TransactionException {
        TransactionStatus status = new TransactionStatus();
        try {
            action.doInTransaction(status);
        }
        catch (RuntimeException e) {
            transaction.rollback();
            throw e;
        }
        if (status.isRollbackOnly()) {
            transaction.setRollbackOnly(true);
        }
        transaction.commit();
    }
}

