/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.jfaster.mango.type.TypeException;
import org.jfaster.mango.type.TypeHandler;
import org.jfaster.mango.util.jdbc.JdbcType;

public abstract class BaseTypeHandler<T>
implements TypeHandler<T> {
    @Override
    public void setParameter(PreparedStatement ps, int index, @Nullable T parameter) throws SQLException {
        JdbcType jdbcType = this.getJdbcType();
        if (parameter == null) {
            try {
                ps.setNull(index, jdbcType.TYPE_CODE);
            }
            catch (SQLException e) {
                throw new TypeException("Error setting null for parameter #" + index + " with JdbcType " + (Object)((Object)jdbcType) + ", try setting a different JdbcType for this parameter", e);
            }
        }
        try {
            this.setNonNullParameter(ps, index, parameter, jdbcType);
        }
        catch (Exception e) {
            throw new TypeException("Error setting non null for parameter #" + index + " with JdbcType " + (Object)((Object)jdbcType) + ", try setting a different JdbcType for this parameter", e);
        }
    }

    @Override
    public T getResult(ResultSet rs, int index) throws SQLException {
        T result;
        try {
            result = this.getNullableResult(rs, index);
        }
        catch (Exception e) {
            throw new TypeException("Error attempting to get column #" + index + " from result set", e);
        }
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public abstract void setNonNullParameter(PreparedStatement var1, int var2, T var3, JdbcType var4) throws SQLException;

    public abstract T getNullableResult(ResultSet var1, int var2) throws SQLException;

    public abstract JdbcType getJdbcType();
}

