/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.type;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jfaster.mango.type.BaseTypeHandler;
import org.jfaster.mango.type.ByteArrayUtils;
import org.jfaster.mango.util.jdbc.JdbcType;

public class BlobByteObjectArrayTypeHandler
extends BaseTypeHandler<Byte[]> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Byte[] parameter, JdbcType jdbcType) throws SQLException {
        ByteArrayInputStream bis = new ByteArrayInputStream(ByteArrayUtils.convertToPrimitiveArray(parameter));
        ps.setBinaryStream(i, (InputStream)bis, parameter.length);
    }

    @Override
    public Byte[] getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Blob blob = rs.getBlob(columnIndex);
        return this.getBytes(blob);
    }

    private Byte[] getBytes(Blob blob) throws SQLException {
        Byte[] returnValue = null;
        if (blob != null) {
            returnValue = ByteArrayUtils.convertToObjectArray(blob.getBytes(1L, (int)blob.length()));
        }
        return returnValue;
    }

    @Override
    public JdbcType getJdbcType() {
        return JdbcType.LONGVARBINARY;
    }
}

