/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.type;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.jfaster.mango.type.BigDecimalTypeHandler;
import org.jfaster.mango.type.BigIntegerTypeHandler;
import org.jfaster.mango.type.BlobByteObjectArrayTypeHandler;
import org.jfaster.mango.type.BlobTypeHandler;
import org.jfaster.mango.type.BooleanTypeHandler;
import org.jfaster.mango.type.ByteArrayTypeHandler;
import org.jfaster.mango.type.ByteObjectArrayTypeHandler;
import org.jfaster.mango.type.ByteTypeHandler;
import org.jfaster.mango.type.CharacterTypeHandler;
import org.jfaster.mango.type.ClobTypeHandler;
import org.jfaster.mango.type.DateOnlyTypeHandler;
import org.jfaster.mango.type.DateTypeHandler;
import org.jfaster.mango.type.DoubleTypeHandler;
import org.jfaster.mango.type.FloatTypeHandler;
import org.jfaster.mango.type.IntegerTypeHandler;
import org.jfaster.mango.type.LongTypeHandler;
import org.jfaster.mango.type.NClobTypeHandler;
import org.jfaster.mango.type.NStringTypeHandler;
import org.jfaster.mango.type.ShortTypeHandler;
import org.jfaster.mango.type.SqlDateTypeHandler;
import org.jfaster.mango.type.SqlTimeTypeHandler;
import org.jfaster.mango.type.SqlTimestampTypeHandler;
import org.jfaster.mango.type.StringTypeHandler;
import org.jfaster.mango.type.TimeOnlyTypeHandler;
import org.jfaster.mango.type.TypeException;
import org.jfaster.mango.type.TypeHandler;
import org.jfaster.mango.util.jdbc.JdbcType;

public final class TypeHandlerRegistry {
    private static final Map<Type, Map<JdbcType, TypeHandler<?>>> TYPE_HANDLER_MAP = new HashMap();

    public static boolean hasTypeHandler(Class<?> javaType) {
        return TypeHandlerRegistry.getNullableTypeHandler(javaType) != null;
    }

    @Nullable
    public static <T> TypeHandler<T> getNullableTypeHandler(Class<T> type) {
        return TypeHandlerRegistry.getNullableTypeHandler(type, null);
    }

    public static <T> TypeHandler<T> getTypeHandler(Class<T> type) {
        return TypeHandlerRegistry.getTypeHandler(type, null);
    }

    @Nullable
    public static <T> TypeHandler<T> getNullableTypeHandler(Class<T> type, JdbcType jdbcType) {
        return TypeHandlerRegistry.getNullableTypeHandler(type, jdbcType);
    }

    public static <T> TypeHandler<T> getTypeHandler(Class<T> type, JdbcType jdbcType) {
        TypeHandler<T> typeHandler = TypeHandlerRegistry.getNullableTypeHandler(type, jdbcType);
        if (typeHandler == null) {
            throw new TypeException("Can't get type handle, java type is '" + type + "', jdbc type is '" + (Object)((Object)jdbcType) + "'");
        }
        return typeHandler;
    }

    @Nullable
    private static <T> TypeHandler<T> getNullableTypeHandler(Type type, JdbcType jdbcType) {
        Map<JdbcType, TypeHandler<?>> jdbcHandlerMap = TYPE_HANDLER_MAP.get(type);
        TypeHandler<?> handler = null;
        if (jdbcHandlerMap != null && (handler = jdbcHandlerMap.get((Object)jdbcType)) == null) {
            handler = jdbcHandlerMap.get(null);
        }
        return handler;
    }

    public static <T> void register(Class<T> javaType, TypeHandler<? extends T> typeHandler) {
        TypeHandlerRegistry.register(javaType, typeHandler);
    }

    private static <T> void register(Type javaType, TypeHandler<? extends T> typeHandler) {
        TypeHandlerRegistry.register(javaType, null, typeHandler);
    }

    public static <T> void register(Class<T> type, JdbcType jdbcType, TypeHandler<? extends T> handler) {
        TypeHandlerRegistry.register(type, jdbcType, handler);
    }

    private static void register(Type javaType, JdbcType jdbcType, TypeHandler<?> handler) {
        Map<JdbcType, TypeHandler<?>> map = TYPE_HANDLER_MAP.get(javaType);
        if (map == null) {
            map = new HashMap();
            TYPE_HANDLER_MAP.put(javaType, map);
        }
        map.put(jdbcType, handler);
    }

    static {
        TypeHandlerRegistry.register(Boolean.class, new BooleanTypeHandler());
        TypeHandlerRegistry.register(Byte.class, new ByteTypeHandler());
        TypeHandlerRegistry.register(Short.class, new ShortTypeHandler());
        TypeHandlerRegistry.register(Integer.class, new IntegerTypeHandler());
        TypeHandlerRegistry.register(Long.class, new LongTypeHandler());
        TypeHandlerRegistry.register(Float.class, new FloatTypeHandler());
        TypeHandlerRegistry.register(Double.class, new DoubleTypeHandler());
        TypeHandlerRegistry.register(Character.class, new CharacterTypeHandler());
        TypeHandlerRegistry.register(Boolean.TYPE, new BooleanTypeHandler());
        TypeHandlerRegistry.register(Byte.TYPE, new ByteTypeHandler());
        TypeHandlerRegistry.register(Short.TYPE, new ShortTypeHandler());
        TypeHandlerRegistry.register(Integer.TYPE, new IntegerTypeHandler());
        TypeHandlerRegistry.register(Long.TYPE, new LongTypeHandler());
        TypeHandlerRegistry.register(Float.TYPE, new FloatTypeHandler());
        TypeHandlerRegistry.register(Double.TYPE, new DoubleTypeHandler());
        TypeHandlerRegistry.register(Character.TYPE, new CharacterTypeHandler());
        TypeHandlerRegistry.register(String.class, new StringTypeHandler());
        TypeHandlerRegistry.register(String.class, JdbcType.CHAR, new StringTypeHandler());
        TypeHandlerRegistry.register(String.class, JdbcType.CLOB, new ClobTypeHandler());
        TypeHandlerRegistry.register(String.class, JdbcType.VARCHAR, new StringTypeHandler());
        TypeHandlerRegistry.register(String.class, JdbcType.LONGVARCHAR, new ClobTypeHandler());
        TypeHandlerRegistry.register(String.class, JdbcType.NVARCHAR, new NStringTypeHandler());
        TypeHandlerRegistry.register(String.class, JdbcType.NCHAR, new NStringTypeHandler());
        TypeHandlerRegistry.register(String.class, JdbcType.NCLOB, new NClobTypeHandler());
        TypeHandlerRegistry.register(BigInteger.class, new BigIntegerTypeHandler());
        TypeHandlerRegistry.register(BigDecimal.class, new BigDecimalTypeHandler());
        TypeHandlerRegistry.register(Byte[].class, new ByteObjectArrayTypeHandler());
        TypeHandlerRegistry.register(Byte[].class, JdbcType.BLOB, new BlobByteObjectArrayTypeHandler());
        TypeHandlerRegistry.register(Byte[].class, JdbcType.LONGVARBINARY, new BlobByteObjectArrayTypeHandler());
        TypeHandlerRegistry.register(byte[].class, new ByteArrayTypeHandler());
        TypeHandlerRegistry.register(byte[].class, JdbcType.BLOB, new BlobTypeHandler());
        TypeHandlerRegistry.register(byte[].class, JdbcType.LONGVARBINARY, new BlobTypeHandler());
        TypeHandlerRegistry.register(java.util.Date.class, new DateTypeHandler());
        TypeHandlerRegistry.register(java.util.Date.class, JdbcType.DATE, new DateOnlyTypeHandler());
        TypeHandlerRegistry.register(java.util.Date.class, JdbcType.TIME, new TimeOnlyTypeHandler());
        TypeHandlerRegistry.register(Date.class, new SqlDateTypeHandler());
        TypeHandlerRegistry.register(Time.class, new SqlTimeTypeHandler());
        TypeHandlerRegistry.register(Timestamp.class, new SqlTimestampTypeHandler());
    }
}

