/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.util;

import javax.annotation.Nullable;
import org.jfaster.mango.util.Strings;

public class PropertyTokenizer {
    private String name;
    private String children;

    public PropertyTokenizer(@Nullable String fullname) {
        if (fullname != null) {
            int delim = fullname.indexOf(46);
            if (delim > -1) {
                this.name = fullname.substring(0, delim);
                this.children = fullname.substring(delim + 1);
            } else {
                this.name = Strings.emptyToNull(fullname);
                this.children = null;
            }
        }
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getChildren() {
        return this.children;
    }

    public boolean hasCurrent() {
        return this.name != null;
    }

    public boolean hasNext() {
        return this.children != null;
    }

    public PropertyTokenizer next() {
        return new PropertyTokenizer(this.children);
    }
}

