/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.util.bean;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.jfaster.mango.exception.UncheckedException;
import org.jfaster.mango.util.Strings;
import org.jfaster.mango.util.bean.PropertyMeta;
import org.jfaster.mango.util.local.CacheLoader;
import org.jfaster.mango.util.local.DoubleCheckCache;
import org.jfaster.mango.util.local.LoadingCache;

public class BeanUtil {
    private static final int MISS_FLAG = -1;
    private static final LoadingCache<Class<?>, List<PropertyMeta>> cache = new DoubleCheckCache(new CacheLoader<Class<?>, List<PropertyMeta>>(){

        @Override
        public List<PropertyMeta> load(Class<?> clazz) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                List<Field> fields = BeanUtil.fetchField(clazz);
                TreeMap<Integer, PropertyMeta> metaMap = new TreeMap<Integer, PropertyMeta>();
                PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
                int missIndex = fields.size();
                for (PropertyDescriptor pd : pds) {
                    String bname;
                    Method readMethod = pd.getReadMethod();
                    Method writeMethod = pd.getWriteMethod();
                    if (readMethod == null || writeMethod == null) continue;
                    String name = pd.getName();
                    Type type = readMethod.getGenericReturnType();
                    Field field = BeanUtil.tryGetField(readMethod.getDeclaringClass(), name);
                    if (BeanUtil.isBoolean(pd.getPropertyType()) && field == null && (field = BeanUtil.tryGetField(clazz, bname = "is" + Strings.firstLetterToUpperCase(name))) != null) {
                        name = bname;
                    }
                    PropertyMeta meta = new PropertyMeta(name, type, readMethod, writeMethod, BeanUtil.methodAnnos(readMethod), BeanUtil.methodAnnos(writeMethod), BeanUtil.fieldAnnos(field));
                    int index = BeanUtil.indexOfFields(field, fields);
                    if (index == -1) {
                        index = missIndex++;
                    }
                    metaMap.put(index, meta);
                }
                return BeanUtil.transToList(metaMap);
            }
            catch (Exception e) {
                throw new UncheckedException(e.getMessage(), e);
            }
        }
    });

    public static List<PropertyMeta> fetchPropertyMetas(Class<?> clazz) {
        return cache.get(clazz);
    }

    static List<Field> fetchField(Class<?> clazz) {
        LinkedList<Field> fields = new LinkedList<Field>();
        BeanUtil.fillFields(clazz, fields);
        return fields;
    }

    private static void fillFields(Class<?> clazz, List<Field> fields) {
        if (Object.class.equals(clazz)) {
            return;
        }
        BeanUtil.fillFields(clazz.getSuperclass(), fields);
        for (Field field : clazz.getDeclaredFields()) {
            fields.add(field);
        }
    }

    private static boolean isBoolean(Class<?> clazz) {
        return Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz);
    }

    private static int indexOfFields(@Nullable Field field, List<Field> fields) {
        if (field != null) {
            for (int i = 0; i < fields.size(); ++i) {
                if (!field.equals(fields.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Nullable
    private static Field tryGetField(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Set<Annotation> methodAnnos(Method m) {
        HashSet<Annotation> annos = new HashSet<Annotation>();
        for (Annotation anno : m.getAnnotations()) {
            annos.add(anno);
        }
        return annos;
    }

    private static Set<Annotation> fieldAnnos(@Nullable Field f) {
        HashSet<Annotation> annos = new HashSet<Annotation>();
        if (f != null) {
            for (Annotation anno : f.getAnnotations()) {
                annos.add(anno);
            }
        }
        return annos;
    }

    private static List<PropertyMeta> transToList(TreeMap<Integer, PropertyMeta> metaMap) {
        ArrayList<PropertyMeta> metas = new ArrayList<PropertyMeta>();
        for (Integer key : metaMap.keySet()) {
            metas.add(metaMap.get(key));
        }
        return Collections.unmodifiableList(metas);
    }
}

