/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.util.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.annotation.Nullable;
import org.jfaster.mango.util.Objects;

public class PropertyMeta {
    private final String name;
    private final Type type;
    private final Method readMethod;
    private final Method writeMethod;
    private final Set<Annotation> readMethodAnnos;
    private final Set<Annotation> writeMethodAnnos;
    private final Set<Annotation> propertyAnnos;

    public PropertyMeta(String name, Type type, Method readMethod, Method writeMethod, Set<Annotation> readMethodAnnos, Set<Annotation> writeMethodAnnos, Set<Annotation> propertyAnnos) {
        this.name = name;
        this.type = type;
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.readMethodAnnos = readMethodAnnos;
        this.writeMethodAnnos = writeMethodAnnos;
        this.propertyAnnos = propertyAnnos;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    @Nullable
    public <T extends Annotation> T getReadMethodAnno(Class<T> annotationType) {
        for (Annotation anno : this.readMethodAnnos) {
            if (!annotationType.isInstance(anno)) continue;
            return (T)((Annotation)annotationType.cast(anno));
        }
        return null;
    }

    @Nullable
    public <T extends Annotation> T getWriteMethodAnno(Class<T> annotationType) {
        for (Annotation anno : this.writeMethodAnnos) {
            if (!annotationType.isInstance(anno)) continue;
            return (T)((Annotation)annotationType.cast(anno));
        }
        return null;
    }

    @Nullable
    public <T extends Annotation> T getPropertyAnno(Class<T> annotationType) {
        for (Annotation anno : this.propertyAnnos) {
            if (!annotationType.isInstance(anno)) continue;
            return (T)((Annotation)annotationType.cast(anno));
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyMeta)) {
            return false;
        }
        PropertyMeta other = (PropertyMeta)obj;
        return Objects.equal(this.name, other.name) && Objects.equal(this.type, other.type) && Objects.equal(this.readMethod, other.readMethod) && Objects.equal(this.writeMethod, other.writeMethod) && Objects.equal(this.readMethodAnnos, other.readMethodAnnos) && Objects.equal(this.writeMethodAnnos, other.writeMethodAnnos) && Objects.equal(this.propertyAnnos, other.propertyAnnos);
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.type, this.readMethod, this.writeMethod, this.readMethodAnnos, this.writeMethodAnnos, this.propertyAnnos);
    }
}

