/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.util.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jfaster.mango.util.jdbc.JdbcType;

public class ResultSetWrapper {
    private final ResultSet resultSet;
    private final List<String> columnNames = new ArrayList<String>();
    private final List<JdbcType> jdbcTypes = new ArrayList<JdbcType>();

    public ResultSetWrapper(ResultSet rs) throws SQLException {
        this.resultSet = rs;
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int index = 1; index <= columnCount; ++index) {
            String columnName = metaData.getColumnLabel(index);
            if (columnName == null || columnName.length() < 1) {
                columnName = metaData.getColumnName(index);
            }
            this.columnNames.add(columnName.trim());
            this.jdbcTypes.add(JdbcType.forCode(metaData.getColumnType(index)));
        }
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public String getColumnName(int index) {
        return this.columnNames.get(index - 1);
    }

    public JdbcType getJdbcType(int index) {
        return this.jdbcTypes.get(index - 1);
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }
}

