/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.util.local;

import java.util.concurrent.ConcurrentHashMap;
import org.jfaster.mango.util.local.CacheLoader;
import org.jfaster.mango.util.local.LoadingCache;

public class DoubleCheckCache<K, V>
implements LoadingCache<K, V> {
    private final CacheLoader<K, V> loader;
    private final ConcurrentHashMap<K, V> cache = new ConcurrentHashMap();
    private final ConcurrentHashMap<K, Object> locks = new ConcurrentHashMap();

    public DoubleCheckCache(CacheLoader<K, V> loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        V value = this.cache.get(key);
        if (value == null) {
            Object object = this.getLock(key);
            synchronized (object) {
                value = this.cache.get(key);
                if (value == null && (value = this.loader.load(key)) != null) {
                    this.cache.put(key, value);
                }
            }
        }
        return value;
    }

    private Object getLock(K key) {
        Object old;
        Object lock = this.locks.get(key);
        if (lock == null && (old = this.locks.putIfAbsent(key, lock = new Object())) != null) {
            lock = old;
        }
        return lock;
    }
}

