/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.util.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfaster.mango.util.logging.AbstractInternalLogger;
import org.jfaster.mango.util.logging.FormattingTuple;
import org.jfaster.mango.util.logging.MessageFormatter;

public class ConsoleLogger
extends AbstractInternalLogger {
    protected ConsoleLogger(String name) {
        super(name);
    }

    @Override
    public boolean isTraceEnabled() {
        return true;
    }

    @Override
    public void trace(String msg) {
        this.println(msg);
    }

    @Override
    public void trace(String format, Object arg) {
        FormattingTuple ft = MessageFormatter.format(format, arg);
        this.println4FormattingTuple(ft);
    }

    @Override
    public void trace(String format, Object argA, Object argB) {
        FormattingTuple ft = MessageFormatter.format(format, argA, argB);
        this.println4FormattingTuple(ft);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
        this.println4FormattingTuple(ft);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.println(msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isTraceEnabled();
    }

    @Override
    public void debug(String msg) {
        this.trace(msg);
    }

    @Override
    public void debug(String format, Object arg) {
        this.trace(format, arg);
    }

    @Override
    public void debug(String format, Object argA, Object argB) {
        this.trace(format, argA, argB);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.trace(format, arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.trace(msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isTraceEnabled();
    }

    @Override
    public void info(String msg) {
        this.trace(msg);
    }

    @Override
    public void info(String format, Object arg) {
        this.trace(format, arg);
    }

    @Override
    public void info(String format, Object argA, Object argB) {
        this.trace(format, argA, argB);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.trace(format, arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.trace(msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isTraceEnabled();
    }

    @Override
    public void warn(String msg) {
        this.trace(msg);
    }

    @Override
    public void warn(String format, Object arg) {
        this.trace(format, arg);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.trace(format, arguments);
    }

    @Override
    public void warn(String format, Object argA, Object argB) {
        this.trace(format, argA, argB);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.trace(msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isTraceEnabled();
    }

    @Override
    public void error(String msg) {
        this.trace(msg);
    }

    @Override
    public void error(String format, Object arg) {
        this.trace(format, arg);
    }

    @Override
    public void error(String format, Object argA, Object argB) {
        this.trace(format, argA, argB);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.trace(format, arguments);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.trace(msg, t);
    }

    private void println(String msg) {
        System.out.println(this.formatDate(new Date()) + " [" + Thread.currentThread() + "] " + msg);
    }

    private void println(String msg, Throwable t) {
        System.err.println(this.formatDate(new Date()) + " [" + Thread.currentThread() + "] " + msg);
        t.printStackTrace();
    }

    private void println4FormattingTuple(FormattingTuple ft) {
        if (ft.getThrowable() != null) {
            ft.getThrowable().printStackTrace();
        } else {
            this.println(ft.getMessage());
        }
    }

    private String formatDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.SSS");
        return format.format(date);
    }
}

