/*
 * Decompiled with CFR 0.152.
 */
package org.jfaster.mango.util.logging;

import org.jfaster.mango.util.logging.InternalLogger;
import org.jfaster.mango.util.logging.Log4J2LoggerFactory;
import org.jfaster.mango.util.logging.Log4JLoggerFactory;
import org.jfaster.mango.util.logging.NoLoggerFactory;
import org.jfaster.mango.util.logging.Slf4JLoggerFactory;

public abstract class InternalLoggerFactory {
    private static volatile InternalLoggerFactory defaultFactory;

    public static InternalLoggerFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(InternalLoggerFactory defaultFactory) {
        if (defaultFactory == null) {
            throw new NullPointerException("defaultFactory");
        }
        InternalLoggerFactory.defaultFactory = defaultFactory;
    }

    public static InternalLogger getInstance(Class<?> clazz) {
        return InternalLoggerFactory.getInstance(clazz.getName());
    }

    public static InternalLogger getInstance(String name) {
        return InternalLoggerFactory.getDefaultFactory().newInstance(name);
    }

    protected abstract InternalLogger newInstance(String var1);

    static {
        InternalLoggerFactory f;
        String name = InternalLoggerFactory.class.getName();
        try {
            f = new Slf4JLoggerFactory(true);
            f.newInstance(name).debug("Using SLF4J as the default logging framework");
        }
        catch (Throwable t1) {
            try {
                f = Log4J2LoggerFactory.INSTANCE;
                f.newInstance(name).debug("Using Log4J2 as the default logging framework");
            }
            catch (Throwable t2) {
                try {
                    f = Log4JLoggerFactory.INSTANCE;
                    f.newInstance(name).debug("Using Log4J as the default logging framework");
                }
                catch (Throwable t3) {
                    f = NoLoggerFactory.INSTANCE;
                }
            }
        }
        defaultFactory = f;
    }
}

