/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.document;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.jodconverter.document.DocumentFormat;
import org.jodconverter.document.SimpleDocumentFormatRegistry;

public class JsonDocumentFormatRegistry
extends SimpleDocumentFormatRegistry {
    public static JsonDocumentFormatRegistry create(InputStream source) throws IOException {
        return JsonDocumentFormatRegistry.create(IOUtils.toString((InputStream)source, (String)"UTF-8"));
    }

    public static JsonDocumentFormatRegistry create(String source) {
        JsonDocumentFormatRegistry registry = new JsonDocumentFormatRegistry();
        registry.readJsonArray(source);
        return registry;
    }

    protected JsonDocumentFormatRegistry() {
    }

    protected void readJsonArray(String source) {
        Gson gson = new Gson();
        Type collectionType = new TypeToken<Collection<DocumentFormat>>(){}.getType();
        Collection formats = (Collection)gson.fromJson(source, collectionType);
        formats.stream().map(DocumentFormat::unmodifiableCopy).forEach(this::addFormat);
    }
}

