/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.document;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jodconverter.document.DocumentFamily;
import org.jodconverter.document.DocumentFormat;
import org.jodconverter.document.DocumentFormatRegistry;

public class SimpleDocumentFormatRegistry
implements DocumentFormatRegistry {
    private final Map<String, DocumentFormat> fmtsByExtension = new HashMap<String, DocumentFormat>();
    private final Map<String, DocumentFormat> fmtsByMediaType = new HashMap<String, DocumentFormat>();

    public void addFormat(DocumentFormat documentFormat) {
        this.fmtsByExtension.put(StringUtils.lowerCase((String)documentFormat.getExtension()), documentFormat);
        this.fmtsByMediaType.put(StringUtils.lowerCase((String)documentFormat.getMediaType()), documentFormat);
    }

    @Override
    public DocumentFormat getFormatByExtension(String extension) {
        return extension == null ? null : this.fmtsByExtension.get(StringUtils.lowerCase((String)extension));
    }

    @Override
    public DocumentFormat getFormatByMediaType(String mediaType) {
        return mediaType == null ? null : this.fmtsByMediaType.get(StringUtils.lowerCase((String)mediaType));
    }

    @Override
    public Set<DocumentFormat> getOutputFormats(DocumentFamily family) {
        return Optional.ofNullable(family).map(docFam -> this.fmtsByExtension.values().stream().filter(format -> format.getStoreProperties((DocumentFamily)((Object)docFam)) != null).collect(Collectors.toSet())).orElse(new HashSet());
    }
}

