/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.job;

import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import org.jodconverter.DocumentConverter;
import org.jodconverter.document.DefaultDocumentFormatRegistry;
import org.jodconverter.document.DocumentFormat;
import org.jodconverter.document.DocumentFormatRegistry;
import org.jodconverter.job.AbstractConversionJobWithSourceFormatUnspecified;
import org.jodconverter.job.AbstractSourceDocumentSpecs;
import org.jodconverter.job.ConversionJobWithOptionalSourceFormatUnspecified;
import org.jodconverter.job.ConversionJobWithRequiredSourceFormatUnspecified;
import org.jodconverter.job.SourceDocumentSpecsFromFile;
import org.jodconverter.job.SourceDocumentSpecsFromInputStream;
import org.jodconverter.office.InstalledOfficeManagerHolder;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.office.TemporaryFileMaker;

public abstract class AbstractConverter
implements DocumentConverter {
    private static final boolean DEFAULT_CLOSE_STREAM = true;
    protected final OfficeManager officeManager;
    protected final DocumentFormatRegistry formatRegistry;

    protected AbstractConverter(OfficeManager officeManager, DocumentFormatRegistry formatRegistry) {
        OfficeManager manager = officeManager;
        if (manager == null && (manager = InstalledOfficeManagerHolder.getInstance()) == null) {
            throw new IllegalStateException("An office manager is required in order to build a converter.");
        }
        this.officeManager = manager;
        this.formatRegistry = formatRegistry == null ? DefaultDocumentFormatRegistry.getInstance() : formatRegistry;
    }

    @Override
    public ConversionJobWithOptionalSourceFormatUnspecified convert(File source) {
        SourceDocumentSpecsFromFile specs = new SourceDocumentSpecsFromFile(source);
        DocumentFormat format = this.formatRegistry.getFormatByExtension(FilenameUtils.getExtension((String)source.getName()));
        if (format != null) {
            specs.setDocumentFormat(format);
        }
        return this.convert(specs);
    }

    @Override
    public ConversionJobWithRequiredSourceFormatUnspecified convert(InputStream source) {
        return this.convert(source, true);
    }

    @Override
    public ConversionJobWithRequiredSourceFormatUnspecified convert(InputStream source, boolean closeStream) {
        if (this.officeManager instanceof TemporaryFileMaker) {
            return this.convert(new SourceDocumentSpecsFromInputStream(source, (TemporaryFileMaker)((Object)this.officeManager), closeStream));
        }
        throw new IllegalStateException("An office manager must implements the TemporaryFileMaker interface in order to be able to convert InputStream");
    }

    protected abstract AbstractConversionJobWithSourceFormatUnspecified convert(AbstractSourceDocumentSpecs var1);

    @Override
    public DocumentFormatRegistry getFormatRegistry() {
        return this.formatRegistry;
    }

    public static abstract class AbstractConverterBuilder<B extends AbstractConverterBuilder<B>> {
        protected OfficeManager officeManager;
        protected DocumentFormatRegistry formatRegistry;

        protected AbstractConverterBuilder() {
        }

        public B officeManager(OfficeManager manager) {
            Validate.notNull((Object)manager);
            this.officeManager = manager;
            return (B)this;
        }

        public B formatRegistry(DocumentFormatRegistry registry) {
            this.formatRegistry = registry;
            return (B)this;
        }

        protected abstract AbstractConverter build();
    }
}

