/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jodconverter.office.NamedThreadFactory;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.office.OfficeManagerPoolEntryConfig;
import org.jodconverter.office.SuspendableThreadPoolExecutor;
import org.jodconverter.task.OfficeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractOfficeManagerPoolEntry
implements OfficeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOfficeManagerPoolEntry.class);
    protected final OfficeManagerPoolEntryConfig config;
    protected final SuspendableThreadPoolExecutor taskExecutor;
    protected Future<?> currentFuture;

    public AbstractOfficeManagerPoolEntry(OfficeManagerPoolEntryConfig config) {
        this.config = config;
        this.taskExecutor = new SuspendableThreadPoolExecutor(new NamedThreadFactory("OfficeManagerPoolEntry"));
    }

    @Override
    public final void execute(final OfficeTask task) throws OfficeException {
        this.currentFuture = this.taskExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AbstractOfficeManagerPoolEntry.this.doExecute(task);
                return null;
            }
        });
        try {
            LOGGER.debug("Waiting for task to complete...");
            this.currentFuture.get(this.config.getTaskExecutionTimeout(), TimeUnit.MILLISECONDS);
            LOGGER.debug("Task executed successfully");
        }
        catch (TimeoutException timeoutEx) {
            this.handleExecuteTimeoutException(timeoutEx);
            throw new OfficeException("Task did not complete within timeout", timeoutEx);
        }
        catch (ExecutionException executionEx) {
            if (executionEx.getCause() instanceof OfficeException) {
                throw (OfficeException)executionEx.getCause();
            }
            throw new OfficeException("Task failed", executionEx.getCause());
        }
        catch (Exception ex) {
            throw new OfficeException("Task failed", ex);
        }
        finally {
            this.currentFuture = null;
        }
    }

    protected abstract void doExecute(OfficeTask var1) throws Exception;

    protected void handleExecuteTimeoutException(TimeoutException timeoutEx) {
        LOGGER.debug("Handleling task execution timeout...");
    }

    @Override
    public boolean isRunning() {
        return !this.taskExecutor.isShutdown();
    }

    @Override
    public final void start() throws OfficeException {
        if (this.taskExecutor.isShutdown()) {
            throw new IllegalStateException("This office manager (pool entry) has been shutdown.");
        }
        this.doStart();
    }

    protected abstract void doStart() throws OfficeException;

    @Override
    public final void stop() throws OfficeException {
        this.taskExecutor.setAvailable(false);
        this.taskExecutor.shutdownNow();
        this.doStop();
    }

    protected abstract void doStop() throws OfficeException;
}

