/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.office;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class SuspendableThreadPoolExecutor
extends ThreadPoolExecutor {
    private boolean available;
    private final ReentrantLock suspendLock = new ReentrantLock();
    private final Condition availableCondition = this.suspendLock.newCondition();

    public SuspendableThreadPoolExecutor(ThreadFactory threadFactory) {
        super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread thread, Runnable task) {
        super.beforeExecute(thread, task);
        this.suspendLock.lock();
        try {
            while (!this.available) {
                this.availableCondition.await();
            }
        }
        catch (InterruptedException interruptedEx) {
            thread.interrupt();
        }
        finally {
            this.suspendLock.unlock();
        }
    }

    public void setAvailable(boolean available) {
        this.suspendLock.lock();
        try {
            this.available = available;
            if (available) {
                this.availableCondition.signalAll();
            }
        }
        finally {
            this.suspendLock.unlock();
        }
    }
}

