/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jodd.db.DbQuery;
import jodd.db.DbSession;
import jodd.db.DbUtil;
import jodd.db.oom.ColumnData;
import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbListIterator;
import jodd.db.oom.DbOomManager;
import jodd.db.oom.DbOomUtil;
import jodd.db.oom.DbSqlGenerator;
import jodd.db.oom.JoinHintResolver;
import jodd.db.oom.mapper.DefaultResultSetMapper;
import jodd.db.oom.mapper.ResultSetMapper;
import jodd.db.oom.sqlgen.ParameterValue;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.util.StringUtil;

public class DbOomQuery
extends DbQuery {
    private static final Logger log = LoggerFactory.getLogger(DbOomQuery.class);
    protected DbSqlGenerator sqlgen;
    protected DbOomManager dbOomManager = DbOomManager.getInstance();
    protected String[] hints;
    protected JoinHintResolver hintResolver = this.dbOomManager.getHintResolver();
    protected boolean cacheEntities = this.dbOomManager.isCacheEntitiesInResultSet();
    protected boolean entityAwareMode = this.dbOomManager.isEntityAwareMode();

    public DbOomQuery(Connection conn, String sqlString) {
        super(conn, sqlString);
    }

    public static DbOomQuery query(Connection conn, String sqlString) {
        return new DbOomQuery(conn, sqlString);
    }

    public DbOomQuery(DbSession session, String sqlString) {
        super(session, sqlString);
    }

    public static DbOomQuery query(DbSession session, String sqlString) {
        return new DbOomQuery(session, sqlString);
    }

    public DbOomQuery(String sqlString) {
        super(sqlString);
    }

    public static DbOomQuery query(String sqlString) {
        return new DbOomQuery(sqlString);
    }

    public DbOomQuery(Connection conn, DbSqlGenerator sqlgen) {
        super(conn, sqlgen.generateQuery());
        this.sqlgen = sqlgen;
    }

    public static DbOomQuery query(Connection conn, DbSqlGenerator sqlgen) {
        return new DbOomQuery(conn, sqlgen);
    }

    public DbOomQuery(DbSession session, DbSqlGenerator sqlgen) {
        super(session, sqlgen.generateQuery());
        this.sqlgen = sqlgen;
    }

    public static DbOomQuery query(DbSession session, DbSqlGenerator sqlgen) {
        return new DbOomQuery(session, sqlgen);
    }

    public DbOomQuery(DbSqlGenerator sqlgen) {
        super(sqlgen.generateQuery());
        this.sqlgen = sqlgen;
    }

    public static DbOomQuery query(DbSqlGenerator sqlgen) {
        return new DbOomQuery(sqlgen);
    }

    public DbOomManager getManager() {
        return this.dbOomManager;
    }

    @Override
    protected void prepareQuery() {
        Map<String, ParameterValue> parameters;
        String[] joinHints;
        super.prepareQuery();
        if (this.sqlgen == null) {
            return;
        }
        if (this.hints == null && (joinHints = this.sqlgen.getJoinHints()) != null) {
            this.withHints(joinHints);
        }
        if ((parameters = this.sqlgen.getQueryParameters()) == null) {
            return;
        }
        for (Map.Entry<String, ParameterValue> entry : parameters.entrySet()) {
            String paramName = entry.getKey();
            ParameterValue param = entry.getValue();
            DbEntityColumnDescriptor dec = param.getColumnDescriptor();
            if (dec == null) {
                this.setObject(paramName, param.getValue());
                continue;
            }
            this.resolveColumnDbSqlType(this.connection, dec);
            this.setObject(paramName, param.getValue(), dec.getSqlTypeClass(), dec.getDbSqlType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveColumnDbSqlType(Connection connection, DbEntityColumnDescriptor dec) {
        if (dec.dbSqlType != Integer.MAX_VALUE) {
            return;
        }
        ResultSet rs = null;
        DbEntityDescriptor ded = dec.getDbEntityDescriptor();
        try {
            DatabaseMetaData dmd = connection.getMetaData();
            rs = dmd.getColumns(null, ded.getSchemaName(), ded.getTableName(), dec.getColumnName());
            if (rs.next()) {
                dec.dbSqlType = rs.getInt("DATA_TYPE");
            } else {
                dec.dbSqlType = Integer.MIN_VALUE;
                if (log.isWarnEnabled()) {
                    log.warn("Column SQL type not available: " + ded.toString() + '.' + dec.getColumnName());
                }
            }
            DbUtil.close(rs);
        }
        catch (SQLException sex) {
            dec.dbSqlType = Integer.MIN_VALUE;
            if (log.isWarnEnabled()) {
                log.warn("Column SQL type not resolved: " + ded.toString() + '.' + dec.getColumnName(), sex);
            }
        }
        finally {
            DbUtil.close(rs);
        }
    }

    public DbOomQuery withHints(String hint) {
        this.hints = StringUtil.splitc(hint, ',');
        return this;
    }

    public DbOomQuery withHints(String ... hints) {
        this.hints = hints;
        return this;
    }

    protected Object resolveRowResults(Object[] row) {
        return (row = this.hintResolver.join(row, this.hints)).length == 1 ? row[0] : row;
    }

    public DbOomQuery cacheEntities(boolean cacheEntities) {
        this.cacheEntities = cacheEntities;
        return this;
    }

    protected ResultSetMapper executeAndBuildResultSetMapper() {
        ResultSet resultSet = this.execute();
        return this.createResultSetMapper(resultSet);
    }

    protected ResultSetMapper createResultSetMapper(ResultSet resultSet) {
        Map<String, ColumnData> columnAliases = this.sqlgen != null ? this.sqlgen.getColumnData() : null;
        return new DefaultResultSetMapper(resultSet, columnAliases, this.cacheEntities, this);
    }

    public DbOomQuery entityAwareMode(boolean entityAware) {
        if (entityAware) {
            this.cacheEntities = true;
        }
        this.entityAwareMode = entityAware;
        return this;
    }

    public <T> Iterator<T> iterate(Class ... types) {
        return this.iterate(types, this.autoClose);
    }

    public <T> Iterator<T> iterate() {
        return this.iterate(null, this.autoClose);
    }

    protected <T> Iterator<T> iterate(Class[] types, boolean close) {
        return new DbListIterator(this, types, close);
    }

    public <T> List<T> list(Class ... types) {
        return this.list(types, -1, this.autoClose);
    }

    public <T> List<T> list() {
        return this.list(null, -1, this.autoClose);
    }

    public <T> List<T> list(int max, Class ... types) {
        return this.list(types, max, this.autoClose);
    }

    public <T> List<T> list(int max) {
        return this.list(null, max, this.autoClose);
    }

    protected <T> List<T> list(Class[] types, int max, boolean close) {
        ArrayList<Object> result = new ArrayList<Object>(DbOomUtil.initialCollectionSize(max));
        ResultSetMapper rsm = this.executeAndBuildResultSetMapper();
        if (types == null) {
            types = rsm.resolveTables();
        }
        Object previousElement = null;
        while (rsm.next()) {
            boolean equals;
            Object[] objects = rsm.parseObjects(types);
            Object row = this.resolveRowResults(objects);
            int size = result.size();
            Object newElement = row;
            if (this.entityAwareMode && size > 0 && previousElement != null && newElement != null && (equals = newElement.getClass().isArray() ? Arrays.equals((Object[])previousElement, (Object[])newElement) : previousElement.equals(newElement))) continue;
            if (size == max) break;
            result.add(newElement);
            previousElement = newElement;
        }
        this.close(rsm, close);
        return result;
    }

    public <T> Set<T> listSet(Class ... types) {
        return this.listSet(types, -1, this.autoClose);
    }

    public <T> Set<T> listSet() {
        return this.listSet(null, -1, this.autoClose);
    }

    public <T> Set<T> listSet(int max, Class ... types) {
        return this.listSet(types, max, this.autoClose);
    }

    public <T> Set<T> listSet(int max) {
        return this.listSet(null, max, this.autoClose);
    }

    protected <T> Set<T> listSet(Class[] types, int max, boolean close) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(DbOomUtil.initialCollectionSize(max));
        ResultSetMapper rsm = this.executeAndBuildResultSetMapper();
        if (types == null) {
            types = rsm.resolveTables();
        }
        Object previousElement = null;
        while (rsm.next()) {
            boolean equals;
            Object[] objects = rsm.parseObjects(types);
            Object row = this.resolveRowResults(objects);
            int size = result.size();
            Object newElement = row;
            if (this.entityAwareMode && size > 0 && previousElement != null && newElement != null && (equals = newElement.getClass().isArray() ? Arrays.equals((Object[])previousElement, (Object[])newElement) : previousElement.equals(newElement))) continue;
            if (size == max) break;
            result.add(newElement);
            previousElement = newElement;
        }
        this.close(rsm, close);
        return result;
    }

    public <T> T find(Class ... types) {
        return this.find(types, this.autoClose, null);
    }

    public <T> T find() {
        return this.find(null, this.autoClose, null);
    }

    protected <T> T find(Class[] types, boolean close, ResultSet resultSet) {
        if (resultSet == null) {
            resultSet = this.execute();
        }
        ResultSetMapper rsm = this.createResultSetMapper(resultSet);
        DbListIterator iterator = new DbListIterator(this, types, rsm, false);
        T result = null;
        if (iterator.hasNext()) {
            result = (T)iterator.next();
        }
        this.close(rsm, close);
        return result;
    }

    public <T> T findGeneratedKey(Class<T> type) {
        return this.find(new Class[]{type}, false, this.getGeneratedColumns());
    }

    public Object findGeneratedColumns(Class ... types) {
        return this.find(types, false, this.getGeneratedColumns());
    }

    @Override
    public DbOomQuery autoClose() {
        super.autoClose();
        return this;
    }

    protected void close(ResultSetMapper rsm, boolean closeQuery) {
        if (closeQuery) {
            this.close();
        } else {
            this.closeResultSet(rsm.getResultSet());
        }
    }
}

