/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jodd.madvoc.ActionWrapper;
import jodd.madvoc.BaseActionWrapperStack;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ContextInjectorComponent;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.injector.Target;
import jodd.petite.meta.PetiteInject;
import jodd.util.ClassUtil;

public abstract class WrapperManager<T extends ActionWrapper> {
    @PetiteInject
    protected ContextInjectorComponent contextInjectorComponent;
    @PetiteInject
    protected MadvocConfig madvocConfig;
    protected Map<String, T> wrappers = new HashMap<String, T>();

    protected WrapperManager() {
    }

    protected Set<T> getAll() {
        HashSet<T> set = new HashSet<T>(this.wrappers.size());
        set.addAll(this.wrappers.values());
        return set;
    }

    public T lookup(String name) {
        return (T)((ActionWrapper)this.wrappers.get(name));
    }

    public T resolve(Class<? extends T> wrapperClass) {
        String wrapperClassName = wrapperClass.getName();
        T wrapper = this.lookup(wrapperClassName);
        if (wrapper == null) {
            wrapper = this.createWrapper(wrapperClass);
            this.initializeWrapper(wrapper);
            this.wrappers.put(wrapperClassName, wrapper);
        }
        return wrapper;
    }

    public T[] resolveAll(Class<? extends T>[] wrapperClasses) {
        if (wrapperClasses == null) {
            return null;
        }
        wrapperClasses = this.expand(wrapperClasses);
        ActionWrapper[] result = this.createArray(wrapperClasses.length);
        for (int i = 0; i < wrapperClasses.length; ++i) {
            result[i] = this.resolve(wrapperClasses[i]);
        }
        return result;
    }

    protected abstract T[] createArray(int var1);

    protected void initializeWrapper(T wrapper) {
        this.contextInjectorComponent.injectContext(new Target(wrapper));
        wrapper.init();
    }

    protected abstract Class<? extends T>[] getDefaultWrappers();

    protected abstract Class<? extends T> getDefaultWebAppWrapper();

    protected Class<? extends T>[] expand(Class<? extends T>[] actionWrappers) {
        if (actionWrappers == null) {
            return null;
        }
        ArrayList list = new ArrayList(actionWrappers.length);
        list.addAll(Arrays.asList(actionWrappers));
        int i = 0;
        while (i < list.size()) {
            Class wrapperClass = (Class)list.get(i);
            if (wrapperClass == null) continue;
            if (wrapperClass.equals(this.getDefaultWebAppWrapper())) {
                list.remove(i);
                Class<T>[] defaultWrappers = this.getDefaultWrappers();
                if (defaultWrappers == null) continue;
                int ndx = i;
                for (Class<T> defaultWrapper : defaultWrappers) {
                    if (defaultWrapper.equals(this.getDefaultWebAppWrapper())) {
                        throw new MadvocException("Default wrapper list is self-contained (cyclic dependency)!");
                    }
                    list.add(ndx, defaultWrapper);
                    ++ndx;
                }
                continue;
            }
            if (ClassUtil.isTypeOf(wrapperClass, BaseActionWrapperStack.class)) {
                BaseActionWrapperStack stack = (BaseActionWrapperStack)this.resolve(wrapperClass);
                list.remove(i);
                Class<T>[] stackWrappers = stack.getWrappers();
                if (stackWrappers != null) {
                    list.addAll(i, Arrays.asList(stackWrappers));
                }
                --i;
            }
            ++i;
        }
        return list.toArray(new Class[list.size()]);
    }

    protected <R extends T> R createWrapper(Class<R> wrapperClass) {
        try {
            return (R)((ActionWrapper)wrapperClass.newInstance());
        }
        catch (Exception ex) {
            throw new MadvocException("Invalid Madvoc wrapper: " + wrapperClass, ex);
        }
    }
}

