/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.util.ArrayList;
import java.util.Collection;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.petite.InjectionPointFactory;
import jodd.petite.PropertyInjectionPoint;
import jodd.petite.meta.PetiteInject;
import jodd.util.ClassUtil;

public class PropertyResolver {
    protected final InjectionPointFactory injectionPointFactory;

    public PropertyResolver(InjectionPointFactory injectionPointFactory) {
        this.injectionPointFactory = injectionPointFactory;
    }

    public PropertyInjectionPoint[] resolve(Class type, boolean autowire) {
        PropertyDescriptor[] allPropertyDescriptors;
        ClassDescriptor cd = ClassIntrospector.lookup(type);
        ArrayList<PropertyInjectionPoint> list = new ArrayList<PropertyInjectionPoint>();
        for (PropertyDescriptor propertyDescriptor : allPropertyDescriptors = cd.getAllPropertyDescriptors()) {
            String name;
            Class propertyType;
            if (propertyDescriptor.isGetterOnly() || ClassUtil.isTypeOf(propertyType = propertyDescriptor.getType(), Collection.class)) continue;
            MethodDescriptor writeMethodDescriptor = propertyDescriptor.getWriteMethodDescriptor();
            FieldDescriptor fieldDescriptor = propertyDescriptor.getFieldDescriptor();
            PetiteInject ref = null;
            if (writeMethodDescriptor != null) {
                ref = writeMethodDescriptor.getMethod().getAnnotation(PetiteInject.class);
            }
            if (ref == null && fieldDescriptor != null) {
                ref = fieldDescriptor.getField().getAnnotation(PetiteInject.class);
            }
            if (!autowire && ref == null) continue;
            String[] refName = null;
            if (ref != null && (name = ref.value().trim()).length() != 0) {
                refName = new String[]{name};
            }
            list.add(this.injectionPointFactory.createPropertyInjectionPoint(propertyDescriptor, refName));
        }
        PropertyInjectionPoint[] fields = list.isEmpty() ? PropertyInjectionPoint.EMPTY : list.toArray(new PropertyInjectionPoint[list.size()]);
        return fields;
    }
}

