/*
 * Decompiled with CFR 0.152.
 */
package jodd.cache;

import java.io.File;
import jodd.cache.Cache;
import jodd.cache.FileCache;
import jodd.cache.LFUCache;

public class FileLFUCache
extends FileCache {
    public FileLFUCache(int maxSize) {
        this(maxSize, maxSize / 2, 0L);
    }

    public FileLFUCache(int maxSize, int maxFileSize) {
        this(maxSize, maxFileSize, 0L);
    }

    public FileLFUCache(int maxSize, int maxFileSize, long timeout) {
        super(maxSize, maxFileSize, timeout);
    }

    @Override
    protected Cache<File, byte[]> createCache() {
        return new LFUCache<File, byte[]>(0, this.timeout){

            @Override
            public boolean isFull() {
                return FileLFUCache.this.usedSize > FileLFUCache.this.maxSize;
            }

            @Override
            protected boolean isReallyFull(File file) {
                return this.isFull();
            }

            @Override
            protected void onRemove(File key, byte[] cachedObject) {
                FileLFUCache.this.usedSize -= cachedObject.length;
            }
        };
    }
}

