/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class Consumers<T>
implements Consumer<T> {
    private final List<Consumer<T>> consumerList = new ArrayList<Consumer<T>>();
    private boolean parallel = false;

    public Consumers(Consumer<T> ... consumers) {
        Collections.addAll(this.consumerList, consumers);
    }

    public Consumers(Iterable<Consumers<T>> consumers) {
        consumers.forEach(this.consumerList::add);
    }

    public static <R> Consumers<R> empty() {
        return new Consumers(new Consumer[0]);
    }

    public static <R> Consumers<R> of(Consumer<R> ... consumers) {
        return new Consumers<R>(consumers);
    }

    public static <R> Consumers<R> of(Iterable<Consumer<R>> consumers) {
        return new Consumers<R>(consumers);
    }

    public Consumers<T> add(Consumer<T> consumer) {
        this.consumerList.add(consumer);
        return this;
    }

    public Consumers<T> addAll(Consumer<T> ... consumers) {
        Collections.addAll(this.consumerList, consumers);
        return this;
    }

    public Consumers<T> parallel(boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    @Override
    public void accept(T t) {
        if (this.parallel) {
            this.consumerList.parallelStream().forEach(consumer -> consumer.accept(t));
        } else {
            this.consumerList.forEach(consumer -> consumer.accept(t));
        }
    }

    public boolean isEmpty() {
        return this.consumerList.isEmpty();
    }

    public Consumer clear() {
        this.consumerList.clear();
        return this;
    }

    public Consumers<T> remove(Consumer<T> consumer) {
        this.consumerList.remove(consumer);
        return this;
    }
}

