/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import jodd.bean.BeanUtil;
import jodd.db.DbManager;
import jodd.db.DbQueryBase;
import jodd.db.DbSession;
import jodd.db.DbSqlException;
import jodd.db.DbUtil;
import jodd.db.querymap.QueryMap;
import jodd.db.type.SqlType;
import jodd.db.type.SqlTypeManager;
import jodd.util.CharUtil;
import jodd.util.collection.IntArrayList;

public class DbQuery
extends DbQueryBase {
    public DbQuery(Connection conn, String sqlString) {
        this.connection = conn;
        this.sqlString = this.preprocessSql(sqlString);
    }

    public DbQuery(DbSession session, String sqlString) {
        this.initSession(session);
        this.session.attachQuery(this);
        this.sqlString = this.preprocessSql(sqlString);
    }

    public DbQuery(String sqlString) {
        this((DbSession)null, sqlString);
    }

    protected String preprocessSql(String sqlString) {
        String sqlFromMap;
        if (sqlString.charAt(0) == '{') {
            return sqlString;
        }
        if (!CharUtil.isAlpha((char)sqlString.charAt(0))) {
            sqlString = sqlString.substring(1);
        } else if (sqlString.indexOf(32) != -1) {
            return sqlString;
        }
        QueryMap queryMap = DbManager.getInstance().getQueryMap();
        if (queryMap != null && (sqlFromMap = queryMap.getQuery(sqlString)) != null) {
            sqlString = sqlFromMap.trim();
        }
        return sqlString;
    }

    public void clearParameters() {
        this.init();
        if (this.preparedStatement == null) {
            return;
        }
        try {
            this.preparedStatement.clearParameters();
        }
        catch (SQLException sex) {
            throw new DbSqlException(sex);
        }
    }

    private void throwSetParamError(int index, Exception ex) {
        throw new DbSqlException(this, "Invalid SQL parameter with index: " + index, ex);
    }

    private void throwSetParamError(String param, Exception ex) {
        throw new DbSqlException(this, "Invalid SQL parameter with name: " + param, ex);
    }

    public void setNull(int index, int type) {
        this.initPrepared();
        try {
            this.preparedStatement.setNull(index, type);
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "Failed to set null to parameter: " + index, sex);
        }
    }

    public void setNull(String param, int type) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setNull(positions.get(i), type);
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "Failed to set null to parameter: " + param, sex);
        }
    }

    public void setNull(int index, int type, String typeName) {
        this.initPrepared();
        try {
            this.preparedStatement.setNull(index, type, typeName);
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "Failed to set null to parameter: " + index, sex);
        }
    }

    public void setNull(String param, int value, String typeName) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setNull(positions.get(i), value, typeName);
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException(this, "Failed to set null to parameter: " + param, sex);
        }
    }

    public void setInteger(int index, int value) {
        this.initPrepared();
        try {
            this.preparedStatement.setInt(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setInteger(String param, int value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setInt(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void outInteger(int index) {
        this.registerOutParameter(index, 4);
    }

    public void outInteger(String param) {
        this.registerOutParameter(param, 4);
    }

    public void setInteger(int index, Number value) {
        if (value == null) {
            this.setNull(index, 4);
            return;
        }
        this.setInteger(index, value.intValue());
    }

    public void setInteger(String param, Number value) {
        if (value == null) {
            this.setNull(param, 4);
            return;
        }
        this.setInteger(param, value.intValue());
    }

    public void setBoolean(int index, boolean value) {
        this.initPrepared();
        try {
            this.preparedStatement.setBoolean(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setBoolean(String param, boolean value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setBoolean(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void outBoolean(int index) {
        this.registerOutParameter(index, 16);
    }

    public void outBoolean(String param) {
        this.registerOutParameter(param, 16);
    }

    public void setBoolean(int index, Boolean value) {
        if (value == null) {
            this.setNull(index, 16);
            return;
        }
        this.setBoolean(index, (boolean)value);
    }

    public void setBoolean(String param, Boolean value) {
        if (value == null) {
            this.setNull(param, 16);
            return;
        }
        this.setBoolean(param, (boolean)value);
    }

    public void setLong(int index, long value) {
        this.initPrepared();
        try {
            this.preparedStatement.setLong(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setLong(String param, long value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setLong(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setLong(int index, Number value) {
        if (value == null) {
            this.setNull(index, 4);
            return;
        }
        this.setLong(index, value.longValue());
    }

    public void setLong(String param, Number value) {
        if (value == null) {
            this.setNull(param, 4);
            return;
        }
        this.setLong(param, value.longValue());
    }

    public void setByte(int index, byte value) {
        this.initPrepared();
        try {
            this.preparedStatement.setByte(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setByte(String param, byte value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setByte(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void outByte(int index) {
        this.registerOutParameter(index, 5);
    }

    public void outByte(String param) {
        this.registerOutParameter(param, 5);
    }

    public void setByte(int index, Number value) {
        if (value == null) {
            this.setNull(index, 5);
            return;
        }
        this.setByte(index, value.byteValue());
    }

    public void setByte(String param, Number value) {
        if (value == null) {
            this.setNull(param, 5);
            return;
        }
        this.setByte(param, value.byteValue());
    }

    public void setBytes(int index, byte[] value) {
        this.initPrepared();
        try {
            this.preparedStatement.setBytes(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setBytes(String param, byte[] value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setBytes(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setDouble(int index, double value) {
        this.initPrepared();
        try {
            this.preparedStatement.setDouble(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setDouble(String param, double value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setDouble(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void outDouble(int index) {
        this.registerOutParameter(index, 8);
    }

    public void outDouble(String param) {
        this.registerOutParameter(param, 8);
    }

    public void setDouble(int index, Number value) {
        if (value == null) {
            this.setNull(index, 8);
            return;
        }
        this.setDouble(index, value.doubleValue());
    }

    public void setDouble(String param, Number value) {
        if (value == null) {
            this.setNull(param, 8);
            return;
        }
        this.setDouble(param, value.doubleValue());
    }

    public void setFloat(int index, float value) {
        this.initPrepared();
        try {
            this.preparedStatement.setFloat(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setFloat(String param, float value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setFloat(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void outFloat(int index) {
        this.registerOutParameter(index, 6);
    }

    public void outFloat(String param) {
        this.registerOutParameter(param, 6);
    }

    public void setFloat(int index, Number value) {
        if (value == null) {
            this.setNull(index, 6);
            return;
        }
        this.setFloat(index, value.floatValue());
    }

    public void setFloat(String param, Number value) {
        if (value == null) {
            this.setNull(param, 6);
            return;
        }
        this.setFloat(param, value.floatValue());
    }

    public void setShort(int index, short value) {
        this.initPrepared();
        try {
            this.preparedStatement.setShort(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setShort(String param, short value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                int index = positions.get(i);
                this.preparedStatement.setShort(index, value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setShort(int index, Number value) {
        if (value == null) {
            this.setNull(index, 5);
            return;
        }
        this.setShort(index, value.shortValue());
    }

    public void setShort(String param, Number value) {
        if (value == null) {
            this.setNull(param, 5);
            return;
        }
        this.setShort(param, value.shortValue());
    }

    public void setString(int index, String value) {
        this.initPrepared();
        try {
            this.preparedStatement.setString(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setString(String param, String value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setString(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void outString(int index) {
        this.registerOutParameter(index, 12);
    }

    public void outString(String param) {
        this.registerOutParameter(param, 12);
    }

    public void setDate(int index, Date value) {
        this.initPrepared();
        try {
            this.preparedStatement.setDate(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setDate(String param, Date value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setDate(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setTime(int index, Time value) {
        this.initPrepared();
        try {
            this.preparedStatement.setTime(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setTime(String param, Time value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setTime(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setTimestamp(int index, Timestamp value) {
        this.initPrepared();
        try {
            this.preparedStatement.setTimestamp(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setTimestamp(String param, Timestamp value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setTimestamp(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setBigDecimal(int index, BigDecimal value) {
        this.initPrepared();
        try {
            this.preparedStatement.setBigDecimal(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setBigDecimal(String param, BigDecimal value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setBigDecimal(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setBigInteger(int index, BigInteger value) {
        if (value == null) {
            this.setNull(index, 2);
            return;
        }
        this.setLong(index, value.longValue());
    }

    public void setBigInteger(String param, BigInteger value) {
        if (value == null) {
            this.setNull(param, 2);
            return;
        }
        this.setLong(param, value.longValue());
    }

    public void setURL(int index, URL value) {
        this.initPrepared();
        try {
            this.preparedStatement.setURL(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setURL(String param, URL value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setURL(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setBlob(int index, Blob value) {
        this.initPrepared();
        try {
            this.preparedStatement.setBlob(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setBlob(String param, Blob value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setBlob(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setClob(int index, Clob value) {
        this.initPrepared();
        try {
            this.preparedStatement.setClob(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setClob(String param, Clob value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setClob(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setArray(int index, Array value) {
        this.initPrepared();
        try {
            this.preparedStatement.setArray(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setArray(String param, Array value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setArray(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setRef(int index, Ref value) {
        this.initPrepared();
        try {
            this.preparedStatement.setRef(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setRef(String param, Ref value) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setRef(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setAsciiStream(int index, InputStream stream) {
        this.initPrepared();
        try {
            this.preparedStatement.setAsciiStream(index, stream, stream.available());
        }
        catch (IOException | SQLException ioex) {
            this.throwSetParamError(index, ioex);
        }
    }

    public void setAsciiStream(String param, InputStream stream) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setAsciiStream(positions.get(i), stream, stream.available());
            }
        }
        catch (IOException | SQLException ioex) {
            this.throwSetParamError(param, ioex);
        }
    }

    public void setAsciiStream(int index, InputStream stream, int length) {
        this.initPrepared();
        try {
            this.preparedStatement.setAsciiStream(index, stream, length);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setAsciiStream(String param, InputStream stream, int length) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setAsciiStream(positions.get(i), stream, length);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setCharacterStream(int index, Reader reader, int length) {
        this.initPrepared();
        try {
            this.preparedStatement.setCharacterStream(index, reader, length);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setCharacterStream(String param, Reader reader, int length) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setCharacterStream(positions.get(i), reader, length);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setBean(String beanName, Object bean) {
        if (bean == null) {
            return;
        }
        this.init();
        beanName = beanName + '.';
        Iterator<String> it = this.query.iterateNamedParameters();
        while (it.hasNext()) {
            String propertyName;
            String paramName = it.next();
            if (!paramName.startsWith(beanName) || !BeanUtil.declared.hasRootProperty(bean, propertyName = paramName.substring(beanName.length()))) continue;
            Object value = BeanUtil.declared.getProperty(bean, propertyName);
            this.setObject(paramName, value);
        }
    }

    public void setMap(Map parameters) {
        if (parameters == null) {
            return;
        }
        this.init();
        Iterator<String> it = this.query.iterateNamedParameters();
        while (it.hasNext()) {
            String paramName = it.next();
            this.setObject(paramName, parameters.get(paramName));
        }
    }

    public void setObject(int index, Object object, int targetSqlType) {
        this.initPrepared();
        try {
            this.preparedStatement.setObject(index, object, targetSqlType);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setObject(String param, Object object, int targetSqlType) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setObject(positions.get(i), object, targetSqlType);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    void setObject(int index, Object object, int targetSqlType, int scale) {
        this.initPrepared();
        try {
            this.preparedStatement.setObject(index, object, targetSqlType, scale);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    void setObject(String param, Object object, int targetSqlType, int scale) {
        this.initPrepared();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setObject(positions.get(i), object, targetSqlType, scale);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setObject(int index, Object value) {
        this.setObject(index, value, null, 1111);
    }

    public void setObject(int index, Object value, Class<? extends SqlType> sqlTypeClass, int dbSqlType) {
        this.init();
        if (value == null) {
            this.setNull(index, 0);
            return;
        }
        SqlType sqlType = sqlTypeClass != null ? SqlTypeManager.lookupSqlType(sqlTypeClass) : SqlTypeManager.lookup(value.getClass());
        try {
            if (sqlType != null && dbSqlType != Integer.MIN_VALUE) {
                sqlType.storeValue(this.preparedStatement, index, value, dbSqlType);
            } else {
                DbUtil.setPreparedStatementObject(this.preparedStatement, index, value, dbSqlType);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setObject(String param, Object value) {
        this.setObject(param, value, null, 1111);
    }

    public void setObject(String param, Object value, Class<? extends SqlType> sqlTypeClass, int dbSqlType) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        for (int i = 0; i < positions.size(); ++i) {
            this.setObject(positions.get(i), value, sqlTypeClass, dbSqlType);
        }
    }

    public void setObjects(Object ... objects) {
        int index = 1;
        for (Object object : objects) {
            this.setObject(index++, object);
        }
    }

    public void setObjects(String[] names, Object[] values) {
        this.init();
        if (names.length != values.length) {
            throw new DbSqlException(this, "Different number of parameter names and values");
        }
        for (int i = 0; i < names.length; ++i) {
            this.setObject(names[i], values[i]);
        }
    }

    public void setBatch(String name, int[] array, int startingIndex) {
        this.init();
        int batchSize = this.query.getBatchParameterSize(name);
        for (int i = 1; i <= batchSize; ++i) {
            String paramName = name + '.' + i;
            if (startingIndex < array.length) {
                this.setInteger(paramName, array[startingIndex]);
            } else {
                this.setNull(paramName, 4);
            }
            ++startingIndex;
        }
    }

    public void setBatch(String name, long[] array, int startingIndex) {
        this.init();
        int batchSize = this.query.getBatchParameterSize(name);
        for (int i = 1; i <= batchSize; ++i) {
            String paramName = name + '.' + i;
            if (startingIndex < array.length) {
                this.setLong(paramName, array[startingIndex]);
            } else {
                this.setNull(paramName, 4);
            }
            ++startingIndex;
        }
    }

    public void setBatch(String name, Object[] array, int startingIndex) {
        this.init();
        int batchSize = this.query.getBatchParameterSize(name);
        for (int i = 1; i <= batchSize; ++i) {
            String paramName = name + '.' + i;
            if (startingIndex < array.length) {
                this.setObject(paramName, array[startingIndex]);
            } else {
                this.setObject(paramName, null);
            }
            ++startingIndex;
        }
    }

    private void initPrepared() {
        this.init();
        if (this.preparedStatement == null) {
            throw new DbSqlException("Prepared statement not initialized.");
        }
    }

    private void initCallable() {
        this.init();
        if (this.callableStatement == null) {
            throw new DbSqlException("Callable statement not initialized.");
        }
    }

    private void registerOutParameter(int index, int type) {
        this.initCallable();
        try {
            this.callableStatement.registerOutParameter(index, type);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    private void registerOutParameter(String param, int type) {
        this.initCallable();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.callableStatement.registerOutParameter(positions.get(i), type);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public DbQuery autoClose() {
        super.autoClose();
        return this;
    }
}

