/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import jodd.typeconverter.Convert;
import jodd.typeconverter.TypeConverterManager;

public class DbUtil {
    public static void close(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void close(ResultSet resultSet) {
        if (resultSet == null) {
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static long getFirstLong(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return resultSet.getLong(1);
        }
        return -1L;
    }

    public static int getFirstInt(ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return resultSet.getInt(1);
        }
        return -1;
    }

    public static void setPreparedStatementObject(PreparedStatement preparedStatement, int index, Object value, int targetSqlType) throws SQLException {
        if (value == null) {
            preparedStatement.setNull(index, 0);
        }
        switch (targetSqlType) {
            case -1: 
            case 1: 
            case 12: {
                preparedStatement.setString(index, Convert.toString((Object)value));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                preparedStatement.setInt(index, Convert.toIntValue((Object)value));
                break;
            }
            case -5: {
                preparedStatement.setLong(index, Convert.toLongValue((Object)value));
                break;
            }
            case -7: 
            case 16: {
                preparedStatement.setBoolean(index, Convert.toBooleanValue((Object)value));
                break;
            }
            case 91: {
                preparedStatement.setDate(index, (Date)TypeConverterManager.convertType((Object)value, Date.class));
                break;
            }
            case 2: 
            case 3: {
                preparedStatement.setBigDecimal(index, Convert.toBigDecimal((Object)value));
                break;
            }
            case 8: {
                preparedStatement.setDouble(index, Convert.toDoubleValue((Object)value));
                break;
            }
            case 6: 
            case 7: {
                preparedStatement.setFloat(index, Convert.toFloatValue((Object)value));
                break;
            }
            case 92: {
                preparedStatement.setTime(index, (Time)TypeConverterManager.convertType((Object)value, Time.class));
                break;
            }
            case 93: {
                preparedStatement.setTimestamp(index, (Timestamp)TypeConverterManager.convertType((Object)value, Timestamp.class));
                break;
            }
            case -3: 
            case -2: {
                preparedStatement.setBytes(index, (byte[])TypeConverterManager.convertType((Object)value, byte[].class));
                break;
            }
            default: {
                if (targetSqlType != Integer.MIN_VALUE) {
                    preparedStatement.setObject(index, value, targetSqlType);
                    break;
                }
                preparedStatement.setObject(index, value);
            }
        }
    }
}

