/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.debug;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import jodd.db.DbSqlException;
import jodd.db.debug.LoggableAdvice;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.ProxyPointcut;
import jodd.proxetta.asm.ProxettaAsmUtil;
import jodd.proxetta.impl.WrapperProxetta;
import jodd.proxetta.impl.WrapperProxettaBuilder;
import jodd.proxetta.pointcuts.ProxyPointcutSupport;

public class LoggablePreparedStatementFactory {
    protected static Class<PreparedStatement> wrappedPreparedStatement;
    protected static WrapperProxettaBuilder builder;
    protected static Field sqlTemplateField;
    protected static Method getQueryStringMethod;
    protected static WrapperProxetta proxetta;
    private static final ReentrantLock lock;

    public static PreparedStatement create(Connection connection, String sql) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        return LoggablePreparedStatementFactory.wrap(preparedStatement, sql);
    }

    public static PreparedStatement create(Connection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        return LoggablePreparedStatementFactory.wrap(preparedStatement, sql);
    }

    public static PreparedStatement create(Connection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return LoggablePreparedStatementFactory.wrap(preparedStatement, sql);
    }

    public static PreparedStatement create(Connection connection, String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql, autoGeneratedKeys);
        return LoggablePreparedStatementFactory.wrap(preparedStatement, sql);
    }

    public static PreparedStatement create(Connection connection, String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql, columnIndexes);
        return LoggablePreparedStatementFactory.wrap(preparedStatement, sql);
    }

    public static PreparedStatement create(Connection connection, String sql, String[] columnNames) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql, columnNames);
        return LoggablePreparedStatementFactory.wrap(preparedStatement, sql);
    }

    public static WrapperProxetta getProxetta() {
        if (proxetta == null) {
            proxetta = WrapperProxetta.withAspects((ProxyAspect[])new ProxyAspect[]{new ProxyAspect(LoggableAdvice.class, (ProxyPointcut)new ProxyPointcutSupport(){

                public boolean apply(MethodInfo methodInfo) {
                    int argumentsCount = methodInfo.getArgumentsCount();
                    char argumentType = '\u0000';
                    if (argumentsCount >= 1) {
                        argumentType = methodInfo.getArgumentOpcodeType(1);
                    }
                    return methodInfo.getReturnOpcodeType() == 'V' && argumentType == 'I' && methodInfo.isTopLevelMethod() && methodInfo.getMethodName().startsWith("set") && (argumentsCount == 2 || argumentsCount == 3);
                }
            })});
        }
        return proxetta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PreparedStatement wrap(PreparedStatement preparedStatement, String sql) {
        PreparedStatement wrapper;
        block10: {
            if (wrappedPreparedStatement == null) {
                lock.lock();
                try {
                    if (wrappedPreparedStatement != null) break block10;
                    proxetta = LoggablePreparedStatementFactory.getProxetta();
                    builder = proxetta.builder();
                    builder.setTarget(PreparedStatement.class);
                    builder.setTargetProxyClassName(LoggablePreparedStatementFactory.class.getPackage().getName() + '.');
                    wrappedPreparedStatement = builder.define();
                    try {
                        String fieldName = ProxettaAsmUtil.adviceFieldName((String)"sqlTemplate", (int)0);
                        sqlTemplateField = wrappedPreparedStatement.getField(fieldName);
                        String methodName = ProxettaAsmUtil.adviceMethodName((String)"getQueryString", (int)0);
                        getQueryStringMethod = wrappedPreparedStatement.getMethod(methodName, new Class[0]);
                    }
                    catch (Exception ex) {
                        throw new DbSqlException(ex);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
        try {
            wrapper = wrappedPreparedStatement.newInstance();
        }
        catch (Exception ex) {
            throw new DbSqlException(ex);
        }
        builder.injectTargetIntoWrapper((Object)preparedStatement, (Object)wrapper);
        try {
            sqlTemplateField.set(wrapper, sql);
        }
        catch (Exception ex) {
            throw new DbSqlException(ex);
        }
        return wrapper;
    }

    public static String getQueryString(PreparedStatement preparedStatement) {
        try {
            return (String)getQueryStringMethod.invoke((Object)preparedStatement, new Object[0]);
        }
        catch (Exception ex) {
            throw new DbSqlException(ex);
        }
    }

    static {
        lock = new ReentrantLock();
    }
}

