/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import jodd.bean.BeanUtil;
import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbMetaUtil;
import jodd.db.oom.DbOomException;
import jodd.db.oom.naming.ColumnNamingStrategy;
import jodd.db.oom.naming.TableNamingStrategy;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.PropertyDescriptor;

public class DbEntityDescriptor<E> {
    private final Class<E> type;
    private final String entityName;
    private final boolean isAnnotated;
    private final String tableName;
    private final String schemaName;
    private final ColumnNamingStrategy columnNamingStrategy;
    private final Class[] mappedTypes;
    private DbEntityColumnDescriptor[] columnDescriptors;
    private DbEntityColumnDescriptor[] idColumnDescriptors;

    public DbEntityDescriptor(Class<E> type, String schemaName, TableNamingStrategy tableNamingStrategy, ColumnNamingStrategy columnNamingStrategy) {
        this.type = type;
        this.entityName = type.getSimpleName();
        this.isAnnotated = DbMetaUtil.resolveIsAnnotated(type);
        this.schemaName = DbMetaUtil.resolveSchemaName(type, schemaName);
        this.tableName = DbMetaUtil.resolveTableName(type, tableNamingStrategy);
        this.columnNamingStrategy = columnNamingStrategy;
        this.mappedTypes = DbMetaUtil.resolveMappedTypes(type);
    }

    public Class<E> getType() {
        return this.type;
    }

    public boolean isAnnotated() {
        return this.isAnnotated;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public Class[] getMappedTypes() {
        return this.mappedTypes;
    }

    public DbEntityColumnDescriptor[] getColumnDescriptors() {
        this.init();
        return this.columnDescriptors;
    }

    protected void init() {
        if (this.columnDescriptors == null) {
            this.resolveColumnsAndProperties(this.type);
        }
    }

    private void resolveColumnsAndProperties(Class type) {
        PropertyDescriptor[] allProperties = ClassIntrospector.lookup((Class)type).getAllPropertyDescriptors();
        ArrayList<DbEntityColumnDescriptor> decList = new ArrayList<DbEntityColumnDescriptor>(allProperties.length);
        int idcount = 0;
        HashSet<String> names = new HashSet<String>(allProperties.length);
        for (PropertyDescriptor propertyDescriptor : allProperties) {
            DbEntityColumnDescriptor dec = DbMetaUtil.resolveColumnDescriptors(this, propertyDescriptor, this.isAnnotated, this.columnNamingStrategy);
            if (dec == null) continue;
            if (!names.add(dec.getColumnName())) {
                throw new DbOomException("Duplicate column name: " + dec.getColumnName());
            }
            decList.add(dec);
            if (!dec.isId) continue;
            ++idcount;
        }
        if (decList.isEmpty()) {
            throw new DbOomException("No column mappings in entity: " + type);
        }
        this.columnDescriptors = decList.toArray(new DbEntityColumnDescriptor[decList.size()]);
        Arrays.sort(this.columnDescriptors);
        if (idcount > 0) {
            this.idColumnDescriptors = new DbEntityColumnDescriptor[idcount];
            idcount = 0;
            for (DbEntityColumnDescriptor dbEntityColumnDescriptor : this.columnDescriptors) {
                if (!dbEntityColumnDescriptor.isId) continue;
                this.idColumnDescriptors[idcount++] = dbEntityColumnDescriptor;
            }
        }
    }

    public DbEntityColumnDescriptor findByColumnName(String columnName) {
        if (columnName == null) {
            return null;
        }
        this.init();
        for (DbEntityColumnDescriptor columnDescriptor : this.columnDescriptors) {
            if (!columnDescriptor.columnName.equalsIgnoreCase(columnName)) continue;
            return columnDescriptor;
        }
        return null;
    }

    public DbEntityColumnDescriptor findByPropertyName(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        this.init();
        for (DbEntityColumnDescriptor columnDescriptor : this.columnDescriptors) {
            if (!columnDescriptor.propertyName.equals(propertyName)) continue;
            return columnDescriptor;
        }
        return null;
    }

    public String getPropertyName(String columnName) {
        DbEntityColumnDescriptor dec = this.findByColumnName(columnName);
        return dec == null ? null : dec.propertyName;
    }

    public String getColumnName(String propertyName) {
        DbEntityColumnDescriptor dec = this.findByPropertyName(propertyName);
        return dec == null ? null : dec.columnName;
    }

    public int getColumnsCount() {
        this.init();
        return this.columnDescriptors.length;
    }

    public int getIdColumnsCount() {
        this.init();
        return this.idColumnDescriptors == null ? 0 : this.idColumnDescriptors.length;
    }

    public boolean hasIdColumn() {
        return this.getIdColumnsCount() == 1;
    }

    private void ensureSingleIdColumn() {
        this.init();
        if (this.idColumnDescriptors == null) {
            throw new DbOomException("No identity column in entity: " + this.entityName);
        }
        if (this.idColumnDescriptors.length > 1) {
            throw new DbOomException("More then one identity column in entity: " + this.entityName);
        }
    }

    public String getIdColumnName() {
        this.ensureSingleIdColumn();
        return this.idColumnDescriptors[0].getColumnName();
    }

    public String getIdPropertyName() {
        this.ensureSingleIdColumn();
        return this.idColumnDescriptors[0].getPropertyName();
    }

    public Object getIdValue(E object) {
        String propertyName = this.getIdPropertyName();
        return BeanUtil.declared.getProperty(object, propertyName);
    }

    public void setIdValue(E object, Object value) {
        String propertyName = this.getIdPropertyName();
        BeanUtil.declared.setProperty(object, propertyName, value);
    }

    public String getKeyValue(E object) {
        Object idValue = this.getIdValue(object);
        String idValueString = idValue == null ? "null" : idValue.toString();
        return this.type.getName().concat(":").concat(idValueString);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DbEntity: ");
        if (this.schemaName != null) {
            sb.append(this.schemaName);
            sb.append('.');
        }
        sb.append(this.tableName);
        return sb.toString();
    }
}

