/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen;

import java.util.Map;
import jodd.db.DbSession;
import jodd.db.oom.ColumnAliasType;
import jodd.db.oom.ColumnData;
import jodd.db.oom.DbOomQuery;
import jodd.db.oom.DbSqlGenerator;
import jodd.db.oom.sqlgen.DbSqlBuilderException;
import jodd.db.oom.sqlgen.ParameterValue;
import jodd.db.oom.sqlgen.ParsedSql;
import jodd.db.oom.sqlgen.TemplateData;
import jodd.db.oom.sqlgen.TemplateParser;
import jodd.db.oom.sqlgen.chunks.ColumnValueChunk;
import jodd.db.oom.sqlgen.chunks.ColumnsSelectChunk;
import jodd.db.oom.sqlgen.chunks.InsertChunk;
import jodd.db.oom.sqlgen.chunks.MatchChunk;
import jodd.db.oom.sqlgen.chunks.RawSqlChunk;
import jodd.db.oom.sqlgen.chunks.ReferenceChunk;
import jodd.db.oom.sqlgen.chunks.SqlChunk;
import jodd.db.oom.sqlgen.chunks.TableChunk;
import jodd.db.oom.sqlgen.chunks.UpdateSetChunk;
import jodd.db.oom.sqlgen.chunks.ValueChunk;

public class DbSqlBuilder
extends TemplateData
implements DbSqlGenerator {
    protected SqlChunk firstChunk;
    protected SqlChunk lastChunk;
    protected int totalChunks;
    protected static final TemplateParser templateParser = new TemplateParser();
    protected String generatedQuery;

    public DbSqlBuilder() {
    }

    public DbSqlBuilder(String template) {
        this.append(template);
    }

    public static DbSqlBuilder sql() {
        return new DbSqlBuilder();
    }

    public static DbSqlBuilder sql(String template) {
        return new DbSqlBuilder().append(template);
    }

    public DbSqlBuilder reset() {
        this.resetSoft();
        return this;
    }

    public DbSqlBuilder resetAll() {
        this.resetHard();
        return this;
    }

    public ParsedSql parse() {
        return new ParsedSql(this);
    }

    public DbSqlBuilder aliasColumnsAs(ColumnAliasType aliasesType) {
        this.columnAliasType = aliasesType;
        return this;
    }

    public DbSqlBuilder use(String name, Object value) {
        this.setObjectReference(name, value);
        return this;
    }

    public DbSqlBuilder addChunk(SqlChunk chunk) {
        if (this.lastChunk == null) {
            this.lastChunk = this.firstChunk = chunk;
        } else {
            chunk.insertChunkAfter(this.lastChunk);
            this.lastChunk = chunk;
        }
        ++this.totalChunks;
        return this;
    }

    public DbSqlBuilder append(String text) {
        templateParser.parse(this, text);
        return this;
    }

    public DbSqlBuilder appendRaw(String text) {
        this.addChunk(new RawSqlChunk(text));
        return this;
    }

    public DbSqlBuilder $(String text) {
        return this.append(text);
    }

    public DbSqlBuilder $() {
        return this.appendRaw(" ");
    }

    public DbSqlBuilder $(SqlChunk chunk) {
        return this.addChunk(chunk);
    }

    @Override
    public String generateQuery() {
        SqlChunk chunk;
        this.reset();
        for (chunk = this.firstChunk; chunk != null; chunk = chunk.getNextChunk()) {
            chunk.init(this);
        }
        StringBuilder query = new StringBuilder();
        try {
            for (chunk = this.firstChunk; chunk != null; chunk = chunk.getNextChunk()) {
                chunk.process(query);
            }
        }
        catch (DbSqlBuilderException dsbex) {
            dsbex.setQueryString(query.toString());
            throw dsbex;
        }
        this.generatedQuery = query.toString();
        return this.generatedQuery;
    }

    @Override
    public Map<String, ColumnData> getColumnData() {
        return this.columnData;
    }

    @Override
    public Map<String, ParameterValue> getQueryParameters() {
        return this.parameters;
    }

    @Override
    public String[] getJoinHints() {
        if (this.hints == null) {
            return null;
        }
        return this.hints.toArray(new String[this.hints.size()]);
    }

    public DbSqlBuilder table(String entityName) {
        return this.addChunk(new TableChunk(entityName));
    }

    public DbSqlBuilder table(String entityName, String alias) {
        return this.addChunk(new TableChunk(entityName, alias));
    }

    public DbSqlBuilder table(Object entity, String alias) {
        return this.addChunk(new TableChunk(entity, alias));
    }

    public DbSqlBuilder table(Object entity, String alias, String tableReference) {
        return this.addChunk(new TableChunk(entity, alias, tableReference));
    }

    public DbSqlBuilder table(Object entity) {
        return this.addChunk(new TableChunk(entity));
    }

    public DbSqlBuilder column(String reference) {
        return this.addChunk(new ColumnsSelectChunk(reference));
    }

    public DbSqlBuilder column(String tableRef, String columnRef) {
        return this.addChunk(new ColumnsSelectChunk(tableRef, columnRef));
    }

    public DbSqlBuilder columnsAll(String tableRef) {
        return this.addChunk(new ColumnsSelectChunk(tableRef, true));
    }

    public DbSqlBuilder columnsIds(String tableRef) {
        return this.addChunk(new ColumnsSelectChunk(tableRef, false));
    }

    public DbSqlBuilder ref(String columnRef) {
        return this.addChunk(new ReferenceChunk(columnRef));
    }

    public DbSqlBuilder ref(String tableRef, String columnRef) {
        return this.addChunk(new ReferenceChunk(tableRef, columnRef, false));
    }

    public DbSqlBuilder refId(String tableRef) {
        return this.addChunk(new ReferenceChunk(tableRef, null, true));
    }

    public DbSqlBuilder match(String tableRef, Object value) {
        return this.addChunk(new MatchChunk(tableRef, value, 1));
    }

    public DbSqlBuilder match(String tableRef, String objectRef) {
        return this.addChunk(new MatchChunk(tableRef, objectRef, 1));
    }

    public DbSqlBuilder matchIds(String tableRef, Object value) {
        return this.addChunk(new MatchChunk(tableRef, value, 2));
    }

    public DbSqlBuilder matchIds(String tableRef, String objectRef) {
        return this.addChunk(new MatchChunk(tableRef, objectRef, 2));
    }

    public DbSqlBuilder matchAll(String tableRef, Object value) {
        return this.addChunk(new MatchChunk(tableRef, value, 3));
    }

    public DbSqlBuilder matchAll(String tableRef, String objectRef) {
        return this.addChunk(new MatchChunk(tableRef, objectRef, 3));
    }

    public DbSqlBuilder match(String expression) {
        return this.addChunk(new MatchChunk(expression));
    }

    public DbSqlBuilder value(String name, Object value) {
        return this.addChunk(new ValueChunk(name, value));
    }

    public DbSqlBuilder value(Object value) {
        return this.addChunk(new ValueChunk(null, value));
    }

    public DbSqlBuilder valueRef(String objectReference) {
        return this.addChunk(new ValueChunk(objectReference));
    }

    public DbSqlBuilder columnValue(String name, Object value) {
        return this.addChunk(new ColumnValueChunk(name, value));
    }

    public DbSqlBuilder columnValue(Object value) {
        return this.addChunk(new ColumnValueChunk(null, value));
    }

    public DbSqlBuilder columnValueRef(String objectReference) {
        return this.addChunk(new ColumnValueChunk(objectReference));
    }

    public DbSqlBuilder insert(String entityName, Object values) {
        return this.addChunk(new InsertChunk(entityName, values));
    }

    public DbSqlBuilder insert(Class entity, Object values) {
        return this.addChunk(new InsertChunk(entity, values));
    }

    public DbSqlBuilder insert(Object values) {
        return this.addChunk(new InsertChunk(values.getClass(), values));
    }

    public DbSqlBuilder set(String tableRef, Object values) {
        return this.addChunk(new UpdateSetChunk(tableRef, values, 1));
    }

    public DbSqlBuilder setAll(String tableRef, Object values) {
        return this.addChunk(new UpdateSetChunk(tableRef, values, 3));
    }

    public DbOomQuery query() {
        return new DbOomQuery(this);
    }

    public DbOomQuery query(DbSession session) {
        return new DbOomQuery(session, (DbSqlGenerator)this);
    }
}

