/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.PropertyDescriptor;
import jodd.madvoc.MadvocException;
import jodd.madvoc.ScopeData;
import jodd.madvoc.ScopeType;
import jodd.madvoc.meta.In;
import jodd.madvoc.meta.InOut;
import jodd.madvoc.meta.Out;

public class ScopeDataResolver {
    public ScopeData[] resolveScopeData(Class type) {
        ScopeType[] allScopeTypes = ScopeType.values();
        ScopeData[] scopeData = new ScopeData[allScopeTypes.length];
        int count = 0;
        for (ScopeType scopeType : allScopeTypes) {
            ScopeData sd = this.inspectClassScopeData(type, scopeType);
            if (sd != null) {
                ++count;
            }
            scopeData[scopeType.value()] = sd;
        }
        if (count == 0) {
            return null;
        }
        return scopeData;
    }

    public ScopeData[] resolveScopeData(String name, Class type, Annotation[] annotations) {
        ScopeType[] allScopeTypes = ScopeType.values();
        ScopeData[] scopeData = new ScopeData[allScopeTypes.length];
        int count = 0;
        for (ScopeType scopeType : allScopeTypes) {
            ScopeData sd = this.inspectMethodParameterScopeData(name, type, annotations, scopeType);
            if (sd != null) {
                ++count;
            }
            scopeData[scopeType.value()] = sd;
        }
        if (count == 0) {
            return null;
        }
        return scopeData;
    }

    public Class<? extends Annotation> detectAnnotationType(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof In) {
                return annotation.annotationType();
            }
            if (annotation instanceof Out) {
                return annotation.annotationType();
            }
            if (!(annotation instanceof InOut)) continue;
            return annotation.annotationType();
        }
        return null;
    }

    protected ScopeData inspectMethodParameterScopeData(String name, Class type, Annotation[] annotations, ScopeType scopeType) {
        ScopeData sd = new ScopeData();
        int count = 0;
        for (Annotation annotation : annotations) {
            ScopeData.Out scopeDataOut;
            ScopeData.In scopeDataIn;
            if (annotation instanceof In) {
                scopeDataIn = this.inspectIn((In)annotation, scopeType, name, type);
                if (scopeDataIn == null) continue;
                ++count;
                sd.in = new ScopeData.In[]{scopeDataIn};
                continue;
            }
            if (annotation instanceof Out) {
                ScopeData.Out scopeDataOut2 = this.inspectOut((Out)annotation, scopeType, name, type);
                if (scopeDataOut2 == null) continue;
                ++count;
                sd.out = new ScopeData.Out[]{scopeDataOut2};
                continue;
            }
            if (!(annotation instanceof InOut)) continue;
            scopeDataIn = this.inspectIn((InOut)annotation, scopeType, name, type);
            if (scopeDataIn != null) {
                ++count;
                sd.in = new ScopeData.In[]{scopeDataIn};
            }
            if ((scopeDataOut = this.inspectOut((InOut)annotation, scopeType, name, type)) == null) continue;
            ++count;
            sd.out = new ScopeData.Out[]{scopeDataOut};
        }
        if (count == 0) {
            return null;
        }
        return sd;
    }

    protected void saveNameTarget(ScopeData.In ii, String value, String propertyName) {
        if ((value = value.trim()).length() > 0) {
            ii.name = value;
            ii.target = propertyName;
        } else {
            ii.name = propertyName;
            ii.target = null;
        }
    }

    protected void saveNameTarget(ScopeData.Out oi, String value, String propertyName) {
        if ((value = value.trim()).length() > 0) {
            oi.name = value;
            oi.target = propertyName;
        } else {
            oi.name = propertyName;
            oi.target = null;
        }
    }

    protected ScopeData.In inspectIn(In in, ScopeType scopeType, String propertyName, Class propertyType) {
        if (in == null) {
            return null;
        }
        ScopeType scope = in.scope();
        if (scope != scopeType) {
            return null;
        }
        ScopeData.In ii = new ScopeData.In();
        this.saveNameTarget(ii, in.value(), propertyName);
        ii.type = propertyType;
        return ii;
    }

    protected ScopeData.In inspectIn(InOut inOut, ScopeType scopeType, String propertyName, Class propertyType) {
        if (inOut == null) {
            return null;
        }
        ScopeType scope = inOut.scope();
        if (scope != scopeType) {
            return null;
        }
        ScopeData.In ii = new ScopeData.In();
        this.saveNameTarget(ii, inOut.value(), propertyName);
        ii.type = propertyType;
        return ii;
    }

    protected ScopeData.Out inspectOut(Out out, ScopeType scopeType, String propertyName, Class propertyType) {
        if (out == null) {
            return null;
        }
        ScopeType scope = out.scope();
        if (scope != scopeType) {
            return null;
        }
        ScopeData.Out oi = new ScopeData.Out();
        this.saveNameTarget(oi, out.value(), propertyName);
        oi.type = propertyType;
        return oi;
    }

    protected ScopeData.Out inspectOut(InOut inOut, ScopeType scopeType, String propertyName, Class propertyType) {
        if (inOut == null) {
            return null;
        }
        ScopeType scope = inOut.scope();
        if (scope != scopeType) {
            return null;
        }
        ScopeData.Out oi = new ScopeData.Out();
        this.saveNameTarget(oi, inOut.value(), propertyName);
        oi.type = propertyType;
        return oi;
    }

    protected ScopeData inspectClassScopeData(Class actionClass, ScopeType scopeType) {
        ClassDescriptor cd = ClassIntrospector.lookup((Class)actionClass);
        PropertyDescriptor[] allProperties = cd.getAllPropertyDescriptors();
        ArrayList<ScopeData.In> listIn = new ArrayList<ScopeData.In>(allProperties.length);
        ArrayList<ScopeData.Out> listOut = new ArrayList<ScopeData.Out>(allProperties.length);
        for (PropertyDescriptor pd : allProperties) {
            ScopeData.Out oi;
            In in = null;
            if (pd.getFieldDescriptor() != null) {
                in = pd.getFieldDescriptor().getField().getAnnotation(In.class);
            }
            if (in == null && pd.getWriteMethodDescriptor() != null) {
                in = pd.getWriteMethodDescriptor().getMethod().getAnnotation(In.class);
            }
            if (in == null && pd.getReadMethodDescriptor() != null) {
                in = pd.getReadMethodDescriptor().getMethod().getAnnotation(In.class);
            }
            InOut inout = null;
            if (pd.getFieldDescriptor() != null) {
                inout = pd.getFieldDescriptor().getField().getAnnotation(InOut.class);
            }
            if (inout == null && pd.getWriteMethodDescriptor() != null) {
                inout = pd.getWriteMethodDescriptor().getMethod().getAnnotation(InOut.class);
            }
            if (inout == null && pd.getReadMethodDescriptor() != null) {
                inout = pd.getReadMethodDescriptor().getMethod().getAnnotation(InOut.class);
            }
            Out out = null;
            if (pd.getFieldDescriptor() != null) {
                out = pd.getFieldDescriptor().getField().getAnnotation(Out.class);
            }
            if (out == null && pd.getWriteMethodDescriptor() != null) {
                out = pd.getWriteMethodDescriptor().getMethod().getAnnotation(Out.class);
            }
            if (out == null && pd.getReadMethodDescriptor() != null) {
                out = pd.getReadMethodDescriptor().getMethod().getAnnotation(Out.class);
            }
            if (inout != null && (in != null || out != null)) {
                throw new MadvocException("@InOut can not be used with @In or @Out: " + pd.getClassDescriptor().getClass() + '#' + pd.getName());
            }
            ScopeData.In ii = this.inspectIn(in, scopeType, pd.getName(), pd.getType());
            if (ii != null) {
                listIn.add(ii);
            }
            if ((ii = this.inspectIn(inout, scopeType, pd.getName(), pd.getType())) != null) {
                listIn.add(ii);
            }
            if ((oi = this.inspectOut(out, scopeType, pd.getName(), pd.getType())) != null) {
                listOut.add(oi);
            }
            if ((oi = this.inspectOut(inout, scopeType, pd.getName(), pd.getType())) == null) continue;
            listOut.add(oi);
        }
        if (listIn.isEmpty() && listOut.isEmpty()) {
            return null;
        }
        ScopeData scopeData = new ScopeData();
        if (!listIn.isEmpty()) {
            scopeData.in = listIn.toArray(new ScopeData.In[listIn.size()]);
        }
        if (!listOut.isEmpty()) {
            scopeData.out = listOut.toArray(new ScopeData.Out[listOut.size()]);
        }
        return scopeData;
    }
}

