/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.util.concurrent.Callable;
import jodd.exception.UncheckedException;

@FunctionalInterface
public interface Task {
    public static Task of(Runnable runnable) {
        return runnable::run;
    }

    public static Task of(Callable callable) {
        return callable::call;
    }

    default public Runnable toRunnable() {
        return () -> {
            try {
                this.run();
            }
            catch (Exception e) {
                throw new UncheckedException(e);
            }
        };
    }

    default public Callable toCallable() {
        return () -> {
            this.run();
            return null;
        };
    }

    public void run() throws Exception;
}

