/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.token;

import java.security.Principal;
import java.util.Collection;
import org.keycloak.adapters.OidcKeycloakAccount;
import org.keycloak.adapters.spi.KeycloakAccount;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class KeycloakAuthenticationToken
extends AbstractAuthenticationToken
implements Authentication {
    private Principal principal;

    public KeycloakAuthenticationToken(KeycloakAccount account) {
        super(null);
        Assert.notNull((Object)account, (String)"KeycloakAccount cannot be null");
        Assert.notNull((Object)account.getPrincipal(), (String)"KeycloakAccount.getPrincipal() cannot be null");
        this.principal = account.getPrincipal();
        this.setDetails(account);
    }

    public KeycloakAuthenticationToken(KeycloakAccount account, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        Assert.notNull((Object)account, (String)"KeycloakAccount cannot be null");
        Assert.notNull((Object)account.getPrincipal(), (String)"KeycloakAccount.getPrincipal() cannot be null");
        this.principal = account.getPrincipal();
        this.setDetails(account);
        this.setAuthenticated(true);
    }

    public Object getCredentials() {
        return this.getAccount().getKeycloakSecurityContext();
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public OidcKeycloakAccount getAccount() {
        return (OidcKeycloakAccount)this.getDetails();
    }
}

